/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3.0
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easybpel.xpath.exp.impl.util;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;


import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.VariablePart;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;



public class ExpressionUtil {
	public static String convertVariable2Expression(final VariablePart var) throws XPathExpressionException {
		String expression = null;
		if(var != null) {
			expression = "$" + var.getVariable();
			if(var.getPart() != null) {
				expression = expression + "." + var.getPart();
			}
			if(var.getQuery() != null) {
				if(!var.getQuery().getQueryLanguage().toString().equals("urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0")) {
					throw new XPathExpressionException("this query language (" + var.getQuery().getQueryLanguage() + ") is not recognized. Only XPATH1.0 language (urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0) is supported" );
				}
				if(var.getQuery().getContent().startsWith("/")) {
					expression = expression + var.getQuery().getContent().trim();
				} else {
					expression = expression + "/" + var.getQuery().getContent().trim();
				}
			}
		}
		return expression.trim();
	}

	public static List<String> createXPathExpressionByReplacingPartByElement(final String partName,
			final BPELVariable variable, String xpathExpression, final BPELProcess bpelDefinition)
			throws XPathExpressionException {
		final List<String> xpathExpressions = new ArrayList<String>();


		// remove variable
		String expWithoutVarAndPart = null;
		if(xpathExpression.indexOf("/") > 0) {
			expWithoutVarAndPart = xpathExpression.substring(xpathExpression.indexOf("/"));
		}

		if((expWithoutVarAndPart == null)&&(partName == null)) {
			// get all document
			xpathExpression = "/";
			xpathExpressions.add(xpathExpression);
		} else if(variable.getMessageType() != null) {
			final Message msg = bpelDefinition.getImports().findMessage(variable.getMessageType());

			if(msg == null) {
				throw new XPathExpressionException("BPELError: the message cannot be null: " + variable.getMessageType());
			}


			QName partQName = new QName(variable.getMessageType().getNamespaceURI(), partName);
			final Part part = msg.getPart(partQName);

			if(part == null) {
				throw new XPathExpressionException("Impossible to find part corresponding to " + partName);
			}

			if(part.getElement() != null) {

			    String namespaceURI = part.getElement().inferQName().getNamespaceURI();
				String prefix = bpelDefinition.getNamespaceContext().getPrefix(namespaceURI);
				if(prefix == null) {
					// find ns in all import
					prefix = bpelDefinition.getImports().getNamespaces().getPrefix(namespaceURI);
					if(prefix != null) {
						if(bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, namespaceURI);
						} else {
							// generate new prefix
							int i = 0;
							String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							while(nsAlreadyExist != null) {
								i++;
								nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							}

							prefix = "cns" + i;
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, namespaceURI);
						}
					}
				}

				final String localName = part.getElement().getName();
				if(expWithoutVarAndPart == null) {
					expWithoutVarAndPart = "";
				}


				if(prefix != null) {
					final String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validRpcXpathExpression);
				} 
				final String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedRpcXpathExpression);

				if(prefix != null) {
					final String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validDocXpathExpression);
				} 
				final String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedDocXpathExpression);


			} else if(part.getQName() != null) {

				String prefix = bpelDefinition.getNamespaceContext().getPrefix(part.getQName().getNamespaceURI());
				if(prefix == null) {
					// find ns in all import
					prefix = bpelDefinition.getImports().getNamespaces().getPrefix(part.getType().getNamespaceURI());
					if(prefix != null) {
						if(bpelDefinition.getNamespaceContext().getNamespaceURI(prefix) == null) {
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, part.getType().getNamespaceURI());
						} else {
							// generate new prefix
							int i = 0;
							String nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							while(nsAlreadyExist != null) {
								i++;
								nsAlreadyExist = bpelDefinition.getNamespaceContext().getNamespaceURI("cns" + i);
							}

							prefix = "cns" + i;
							(bpelDefinition.getNamespaceContext()).addNamespace(prefix, part.getType().getNamespaceURI());
						}
					}
				}

				final String localName = part.getQName().getLocalPart();
				if(expWithoutVarAndPart == null) {
					expWithoutVarAndPart = "";
				}

				if(prefix != null) {
					final String validRpcXpathExpression = prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validRpcXpathExpression);
				} 
				final String degradedRpcXpathExpression = localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedRpcXpathExpression);

				if(prefix != null) {
					final String validDocXpathExpression = "/" + prefix + ":" + localName + expWithoutVarAndPart;
					xpathExpressions.add(validDocXpathExpression);
				} 
				final String degradedDocXpathExpression = "/" + localName + expWithoutVarAndPart;
				xpathExpressions.add(degradedDocXpathExpression);

			}

		} else if(variable.getTypeQName() != null) {

			// local variable
			// variable correspond to the element
			xpathExpression = xpathExpression.replace("$", "/");
			xpathExpressions.add(xpathExpression);

			// add prefix to element
			xpathExpression = xpathExpression.replaceFirst("/", "/" + variable.getTypeQName().getPrefix() + ":");
			xpathExpressions.add(xpathExpression);
		} else if(variable.getElement() != null) {
			if(expWithoutVarAndPart == null) {
				expWithoutVarAndPart = "";
			}

			xpathExpression = variable.getElement().getLocalPart() + expWithoutVarAndPart;
			xpathExpressions.add(xpathExpression);

			// local variable
			// variable correspond to the element
			if(expWithoutVarAndPart.trim().length() > 0) {
				xpathExpression = expWithoutVarAndPart.replaceFirst("/", "");
				xpathExpressions.add(xpathExpression);
			}

			// local variable
			// variable correspond to the element
			if(variable.getElement().getPrefix() != null) {
				xpathExpression = variable.getElement().getPrefix() + ":" + variable.getElement().getLocalPart() + expWithoutVarAndPart;
			}
			xpathExpressions.add(xpathExpression);
		}

		return xpathExpressions;
	}
}
