/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutputAssociation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.OutputSet;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCatchEvent;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCatchEvent;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataOutput;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTDataOutputAssociation;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTEventDefinition;

abstract class AbstractTCatchEventImpl<Model extends EJaxbTCatchEvent>
extends AbstractTEventImpl<Model> implements TCatchEvent{

	protected AbstractTCatchEventImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	public DataOutput[] getDataOutput() {
		return createChildrenArray(getModelObject().getDataOutput(),
				EJaxbTDataOutput.class, ANY_QNAME, DataOutputImpl.class);
	}
	
	@Override
    public void addDataOutput(DataOutput d) {
        addToChildren(getModelObject().getDataOutput(), d);
    }

    @Override
    public void removeDataOutput(DataOutput d) {
        removeFromChildren(getModelObject().getDataOutput(), d);
    }

	@Override
	public boolean hasDataOutput() {
		return this.getModelObject().isSetDataOutput();
	}

	@Override
	public void unsetDataOutput() {
		this.getModelObject().unsetDataOutput();

	}

	@Override
	public DataOutputAssociation[] getDataOutputAssociation() {
		return createChildrenArray(getModelObject().getDataOutputAssociation(),
				EJaxbTDataOutputAssociation.class, ANY_QNAME,
				DataOutputAssociationImpl.class);
	}

	@Override
	public boolean hasDataOutputAssociation() {
		return this.getModelObject().isSetDataOutputAssociation();
	}

	@Override
	public void unsetDataOutputAssociation() {
		this.getModelObject().unsetDataOutputAssociation();
	}
	
	@Override
	public void addDataOutputAssociation(DataOutputAssociation doa){
		this.getModelObject().getDataOutputAssociation().add(((DataOutputAssociationImpl)doa).getModelObject());
	}
	
	@Override
	public void removeDataOutputAssociation(DataOutputAssociation doa){
		this.getModelObject().getDataOutputAssociation().remove(((DataOutputAssociationImpl)doa).getModelObject());
	}
	
	@Override
	public OutputSet getOutputSet() {
		return this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getOutputSet(), OutputSetImpl.class);
	}

	@Override
	public void setOutputSet(OutputSet value) {
		this.getModelObject().setOutputSet(((OutputSetImpl)value).getModelObject());
	}

	@Override
	public boolean hasOutputSet() {
		return this.getModelObject().isSetOutputSet();
	}

	@Override
	public EventDefinition[] getEventDefinition() {
		XmlObject[] tab = createChildrenArray(getModelObject().getEventDefinition(), EJaxbTEventDefinition.class, ANY_QNAME);
		EventDefinition[] result = new EventDefinition[tab.length];
		for(int i=0; i<tab.length; i++){
			result[i] = (EventDefinition) tab[i];
		}
		return result;
	}
	
	@Override
	public void addEventDefinition(EventDefinition eventDef){
		addToChildren(getModelObject().getEventDefinition(), eventDef);
	}
	
	@Override
	public void removeEventDefinition(EventDefinition eventDef){
		removeFromChildren(getModelObject().getEventDefinition(), eventDef);
	}

	@Override
	public boolean hasEventDefinition() {
		return this.getModelObject().isSetEventDefinition();
	}

	@Override
	public void unsetEventDefinition() {
		this.getModelObject().unsetEventDefinition();

	}

	@Override
	public QName[] getEventDefinitionRef() {
		List<QName> l = this.getModelObject().getEventDefinitionRef();
		return l.toArray(new QName[l.size()]);
	}
	
	@Override
	public void addEventDefinitionRef(QName ref) {
		getModelObject().getEventDefinitionRef().add(ref);
	}
	
	@Override
	public void removeEventDefinitionRef(QName ref) {
		getModelObject().getEventDefinitionRef().remove(ref);
	}

	@Override
	public boolean hasEventDefinitionRef() {
		return this.getModelObject().isSetEventDefinitionRef();
	}

	@Override
	public void unsetEventDefinitionRef() {
		this.getModelObject().unsetEventDefinitionRef();
	}
	
	@Override
	public boolean isParallelMultiple() {
		return this.getModelObject().isParallelMultiple();
	}

	@Override
	public void setParallelMultiple(boolean value) {
		this.getModelObject().setParallelMultiple(value);
	}

	@Override
	public boolean hasParallelMultiple() {
		return this.getModelObject().isSetParallelMultiple();
	}

	@Override
	public void unsetParallelMultiple() {
		this.getModelObject().unsetParallelMultiple();
	}

}
