/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TAssignment;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTAssignment;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;

class TAssignmentImpl extends AbstractTBaseElementImpl<EJaxbTAssignment>
		implements TAssignment {

	protected TAssignmentImpl(XmlContext xmlContext, EJaxbTAssignment jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public Expression getFrom() {
		if (this.getModelObject().getFrom() != null) {
			return (Expression)(this.getXmlContext().getXmlObjectFactory().wrap(this
					.getModelObject().getFrom()));
		}
		return null;
	}

	@Override
	public void setFrom(Expression value) {
		if(value!=null){
			this.getModelObject().setFrom((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setFrom(null);
		}
	}

	@Override
	public boolean hasFrom() {
		return this.getModelObject().isSetFrom();
	}

	@Override
	public Expression getTo() {
		if (this.getModelObject().getTo() != null) {
			return (Expression)(this.getXmlContext().getXmlObjectFactory().wrap(this
					.getModelObject().getTo()));
		}
		return null;
	}

	@Override
	public void setTo(Expression value) {
		if(value!=null){
			this.getModelObject().setTo((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setTo(null);
		}
	}

	@Override
	public boolean hasTo() {
		return this.getModelObject().isSetTo();
	}

	@Override
	protected Class<? extends EJaxbTAssignment> getCompliantModelClass() {
		return EJaxbTAssignment.class;
	}

}
