/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.eventDefinition.InterruptingBoundaryEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBoundaryEvent;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTBoundaryEvent;

class TBoundaryEventImpl extends AbstractTCatchEventImpl<EJaxbTBoundaryEvent>
		implements TBoundaryEvent {

	protected TBoundaryEventImpl(XmlContext xmlContext,
			EJaxbTBoundaryEvent jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	protected Class<? extends EJaxbTBoundaryEvent> getCompliantModelClass() {
		return EJaxbTBoundaryEvent.class;
	}
	
	@Override
	public void addEventDefinition(EventDefinition eventDef) {
	    if(eventDef instanceof InterruptingBoundaryEventDefinition){
	        super.addEventDefinition(eventDef);
	    }
	    else{
	        throw new IllegalArgumentException("Boundary events do not support such event definitions : "+eventDef.getXmlObjectQName());
	    }
	}

	@Override
	public boolean isCancelActivity() {
		return this.getModelObject().isCancelActivity();
	}

	@Override
	public void setCancelActivity(boolean value) {
		this.getModelObject().isSetCancelActivity();
	}

	@Override
	public boolean hasCancelActivity() {
		return this.getModelObject().isSetCancelActivity();
	}

	@Override
	public void unsetCancelActivity() {
		this.getModelObject().unsetCancelActivity();
	}

	@Override
	public void setAttachedToRef(QName value) {
		this.getModelObject().setAttachedToRef(value);
	}
	
	@Override
	public QName getAttachedToRef() {
		return this.getModelObject().getAttachedToRef();
	}

	@Override
	public boolean hasAttachedToRef() {
		return this.getModelObject().isSetAttachedToRef();
	}

}
