/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TConversationLink;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTConversationLink;

class TConversationLinkImpl extends
		AbstractTBaseElementImpl<EJaxbTConversationLink> implements
		TConversationLink {

	protected TConversationLinkImpl(XmlContext xmlContext,
			EJaxbTConversationLink jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	public String getName() {
		return this.getModelObject().getName();
	}

	@Override
	public void setName(String value) {
		this.getModelObject().setName(value);
	}

	@Override
	public boolean hasName() {
		return this.getModelObject().isSetName();
	}

	@Override
	public QName getSourceRef() {
		return this.getModelObject().getSourceRef();
	}

	@Override
	public void setSourceRef(QName value) {
		this.getModelObject().setSourceRef(value);
	}

	@Override
	public boolean hasSourceRef() {
		return this.getModelObject().isSetSourceRef();
	}

	@Override
	public QName getTargetRef() {
		return this.getModelObject().getTargetRef();
	}

	@Override
	public void setTargetRef(QName value) {
		this.getModelObject().setTargetRef(value);

	}

	@Override
	public boolean hasTargetRef() {
		return this.getModelObject().isSetTargetRef();
	}

	@Override
	protected Class<? extends EJaxbTConversationLink> getCompliantModelClass() {
		return EJaxbTConversationLink.class;
	}

}
