/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TCorrelationPropertyRetrievalExpression;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTCorrelationPropertyRetrievalExpression;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTFormalExpression;

class TCorrelationPropertyRetrievalExpressionImpl extends
		AbstractTBaseElementImpl<EJaxbTCorrelationPropertyRetrievalExpression>
		implements TCorrelationPropertyRetrievalExpression {

	protected TCorrelationPropertyRetrievalExpressionImpl(
			XmlContext xmlContext,
			EJaxbTCorrelationPropertyRetrievalExpression jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public Expression getMessagePath() {
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getMessagePath(),
						ExpressionImpl.class);
	}

	@Override
	public void setMessagePath(Expression value) {
		this.getModelObject().setMessagePath((EJaxbTFormalExpression)((ExpressionImpl)value).getModelObject());
	}

	@Override
	public boolean hasMessagePath() {
		return this.getModelObject().isSetMessagePath();
	}

	@Override
	public QName getMessageRef() {
		return this.getModelObject().getMessageRef();
	}

	@Override
	public void setMessageRef(QName value) {
		this.getModelObject().setMessageRef(value);

	}

	@Override
	public boolean hasMessageRef() {
		return this.getModelObject().isSetMessageRef();
	}

	@Override
	protected Class<? extends EJaxbTCorrelationPropertyRetrievalExpression> getCompliantModelClass() {
		return EJaxbTCorrelationPropertyRetrievalExpression.class;
	}

}
