/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectImpl;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ComplexBehaviorDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataInput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.DataOutput;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Expression;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TMultiInstanceFlowCondition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TMultiInstanceLoopCharacteristics;

import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTComplexBehaviorDefinition;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTExpression;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTMultiInstanceFlowCondition;
import easybox.org.omg.spec.bpmn._20100524.model.EJaxbTMultiInstanceLoopCharacteristics;

class TMultiInstanceLoopCharacteristicsImpl extends
		AbstractTLoopCharacteristicsImpl<EJaxbTMultiInstanceLoopCharacteristics>
		implements TMultiInstanceLoopCharacteristics {

	protected TMultiInstanceLoopCharacteristicsImpl(XmlContext xmlContext,
			EJaxbTMultiInstanceLoopCharacteristics jaxbModel) {
		super(xmlContext, jaxbModel);

	}

	@Override
	protected Class<? extends EJaxbTMultiInstanceLoopCharacteristics> getCompliantModelClass() {
		return EJaxbTMultiInstanceLoopCharacteristics.class;
	}

	@Override
	public Expression getLoopCardinality() {
		return (Expression)
				this.getXmlContext().getXmlObjectFactory()
				.wrap(this.getModelObject().getLoopCardinality());
	}

	@Override
	public void setLoopCardinality(Expression value) {
		if(value!=null){
			this.getModelObject().setLoopCardinality((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
		}
		else{
			this.getModelObject().setLoopCardinality(null);
		}
	}

	@Override
	public boolean hasLoopCardinality() {
		return this.getModelObject().isSetLoopCardinality();
	}

	@Override
	public QName getLoopDataInputRef() {
		return this.getModelObject().getLoopDataInputRef();
	}

	@Override
	public void setLoopDataInputRef(QName value) {
		this.getModelObject().setLoopDataOutputRef(value);
	}

	@Override
	public boolean hasLoopDataInputRef() {
		return this.getModelObject().isSetLoopDataInputRef();
	}

	@Override
	public QName getLoopDataOutputRef() {
		return this.getModelObject().getLoopDataOutputRef();
	}

	@Override
	public void setLoopDataOutputRef(QName value) {
		this.getModelObject().setLoopDataOutputRef(value);
	}

	@Override
	public boolean hasLoopDataOutputRef() {
		return this.getModelObject().isSetLoopDataOutputRef();
	}

	@Override
	public DataInput getInputDataItem() {
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getInputDataItem(), DataInputImpl.class);
	}

	@Override
	public void setInputDataItem(DataInput value) {
		this.getModelObject().setInputDataItem(((DataInputImpl)value).getModelObject());
	}

	@Override
	public boolean hasInputDataItem() {
		return this.getModelObject().isSetInputDataItem();
	}

	@Override
	public DataOutput getOutputDataItem() {
		return this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getOutputDataItem(),
						DataOutputImpl.class);
	}

	@Override
	public void setOutputDataItem(DataOutput value) {
		this.getModelObject().setOutputDataItem(((DataOutputImpl)value).getModelObject());

	}

	@Override
	public boolean hasOutputDataItem() {
		return this.getModelObject().isSetOutputDataItem();
	}

	@Override
	public ComplexBehaviorDefinition[] getComplexBehaviorDefinition() {
		return createChildrenArray(getModelObject()
				.getComplexBehaviorDefinition(),
				EJaxbTComplexBehaviorDefinition.class, ANY_QNAME,
				ComplexBehaviorDefinitionImpl.class);
	}

	@Override
	public boolean hasComplexBehaviorDefinition() {
		return this.getModelObject().isSetComplexBehaviorDefinition();
	}

	@Override
	public void unsetComplexBehaviorDefinition() {
		this.getModelObject().unsetComplexBehaviorDefinition();
	}

	@Override
	public Expression getCompletionCondition() {
		return (Expression) this
				.getXmlContext()
				.getXmlObjectFactory()
				.wrap(this.getModelObject().getCompletionCondition());
	}

	@Override
	public void setCompletionCondition(Expression value) {
		this.getModelObject().setCompletionCondition((EJaxbTExpression) ((AbstractXmlObjectImpl<?>)value).getModelObject());
	}

	@Override
	public boolean hasCompletionCondition() {
		return this.getModelObject().isSetCompletionCondition();
	}

	@Override
	public boolean isIsSequential() {
		return this.getModelObject().isIsSequential();
	}

	@Override
	public void setIsSequential(boolean value) {
		this.getModelObject().setIsSequential(value);
	}

	@Override
	public boolean hasIsSequential() {
		return this.getModelObject().isIsSequential();
	}

	@Override
	public void unsetIsSequential() {
		this.getModelObject().unsetIsSequential();
	}

	public TMultiInstanceFlowCondition getBehavior() {
		if (getModelObject().getBehavior() == null){
			return null;
		}
		TMultiInstanceFlowCondition result = null;
		switch(this.getModelObject().getBehavior()){
		case ALL:
			result = TMultiInstanceFlowCondition.All;
			break;
		case COMPLEX:
			result = TMultiInstanceFlowCondition.Complex;
			break;
		case NONE:
			result = TMultiInstanceFlowCondition.None;
			break;
		case ONE:
			result = TMultiInstanceFlowCondition.One;
			break;
		}
		return result;
	}

	@Override
	public void setBehavior(TMultiInstanceFlowCondition value) {

		if (value == null) {
			this.getModelObject().setBehavior(null);
		} else if (value.equals(TMultiInstanceFlowCondition.All)) {
			getModelObject().setBehavior(EJaxbTMultiInstanceFlowCondition.ALL);
		} else if (value.equals(TMultiInstanceFlowCondition.Complex)) {
			getModelObject().setBehavior(
					EJaxbTMultiInstanceFlowCondition.COMPLEX);
		} else if (value.equals(TMultiInstanceFlowCondition.None)) {
			getModelObject().setBehavior(EJaxbTMultiInstanceFlowCondition.NONE);
		} else if (value.equals(TMultiInstanceFlowCondition.One)) {
			getModelObject().setBehavior(EJaxbTMultiInstanceFlowCondition.ONE);
		}
	}

	@Override
	public boolean hasBehavior() {
		return this.getModelObject().isSetBehavior();
	}

	@Override
	public QName getOneBehaviorEventRef() {
		return this.getModelObject().getOneBehaviorEventRef();
	}

	@Override
	public void setOneBehaviorEventRef(QName value) {
		this.getModelObject().setOneBehaviorEventRef(value);
	}

	@Override
	public boolean hasOneBehaviorEventRef() {
		return this.getModelObject().isSetOneBehaviorEventRef();
	}

	@Override
	public QName getNoneBehaviorEventRef() {
		return this.getModelObject().getNoneBehaviorEventRef();
	}

	@Override
	public void setNoneBehaviorEventRef(QName value) {
		this.getModelObject().setNoneBehaviorEventRef(value);
	}

	@Override
	public boolean hasNoneBehaviorEventRef() {
		return this.getModelObject().isSetNoneBehaviorEventRef();
	}

}
