/*******************************************************************************
 * Easybpmn - Java library for BPMN 2.0 - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 ******************************************************************************/
package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.Bounds;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.type.TShape;

import easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.di.EJaxbShape;

abstract class AbstractTShapeImpl<Model extends EJaxbShape> 
extends AbstractTNodeImpl<Model> implements TShape {
	
	protected AbstractTShapeImpl(XmlContext xmlContext, Model jaxbModel) {
		super(xmlContext, jaxbModel);
	}

	@Override
	public Bounds getBounds() {
		if(this.getModelObject().getBounds()!=null){
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getBounds(), BoundsImpl.class);
		}
		return null;
	}

	@Override
	public boolean hasBounds() {
		return this.getModelObject().isSetBounds();
	}

	@Override
	public void setBounds(Bounds value) {
		if(value!=null){
			this.getModelObject().setBounds(((BoundsImpl)value).getModelObject());
		}
		else{
			this.getModelObject().setBounds(null);
		}
	}

}
