package com.ebmwebsourcing.easybox.easybpmn.bpmn20diagram.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectSchemaBindingImpl;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.Constants;

public class DISchemaBindingImpl extends AbstractXmlObjectSchemaBindingImpl {

    @Override
    public String getOriginatingSchemaDir() {
        return "schema/bpmn20diagram";
    }

    @Override
    public String getOriginatingSchemaName() {
        return "DI.xsd";
    }



    @Override
    public Package getModelObjectPackage() {
        return easybox.com.ebmwebsourcing.easybpmn.bpmndi._2.di.ObjectFactory.class.getPackage();
    }


    @Override
    public String getOriginatingSchemaNamespaceURI() {
        return Constants.DI_NS_URI;
    }


    @SuppressWarnings("unchecked")
    @Override
    public Class[] getFactorableClasses() {
        List<Class> factorableClasses = new ArrayList<Class>();
        
        factorableClasses.add(ExtensionImpl.class);
        
        return factorableClasses.toArray(new Class[factorableClasses.size()]);
    }


    @Override
    protected XmlObject doWrap(XmlContext xmlContext,
            Constructor<? extends XmlObject> xmlObjectImplConstructor,
            ModelObject ModelObjectObject)
    throws InstantiationException, IllegalAccessException,
    InvocationTargetException {
        return (XmlObject)xmlObjectImplConstructor.newInstance(xmlContext, ModelObjectObject);
    }

    @Override
    public String getOriginatingSchemaPreferredNamespacePrefix() {
        return "di";
    }

    @Override
    public String getName() {
        return "DI";
    }


}