package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventBasedGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyplnk20.api.element.Role;




public class BPELGeneratorHelper {


	public static Map<Gateway,Set<SequenceFlow>> findLoopDivergers(WithFlowElements wfe, Collection<? extends FlowElement> starts){
		Map<Gateway,Set<SequenceFlow>> result = new HashMap<Gateway, Set<SequenceFlow>>();

		List<List<FlowElement>> loops = new ArrayList<List<FlowElement>>();
		for(FlowElement start : starts){
			List<FlowElement> visited = new ArrayList<FlowElement>();
			//visited.add(start);

			followPath(start, visited, loops);
		}

		for(List<FlowElement> loop : loops){
			Gateway diverger = null;
			for(int i=0; i<loop.size(); i++){
				if(loop.get(i) instanceof ExclusiveGateway || loop.get(i) instanceof EventBasedGateway){
					if(((FlowNode)loop.get(i)).getOutgoingFlowNodes().size()>1) {
						diverger = (Gateway) loop.get(i);
						break;
					}
				}
			}

			FlowElement next = null;
			int index = loop.indexOf(diverger); 
			if(index==loop.size()-1){
				next = loop.get(0);
			}
			else{
				next = loop.get(index+1);
			}

			SequenceFlow outgoer = null;
			for(SequenceFlow sf : wfe.getFlowElementsByClass(SequenceFlow.class)){
				if(sf.getSourceRef().getId().equals(diverger.getId())
						&& sf.getTargetRef().getId().equals(next.getId())){
					outgoer = sf;
					break;
				}
			}

			if(!result.containsKey(diverger)){
				result.put(diverger, new HashSet<SequenceFlow>());
			}
			result.get(diverger).add(outgoer);
		}

		return result;
	}


	private static void followPath(FlowElement fe, List<FlowElement> visited, List<List<FlowElement>> loops){
		if(visited.contains(fe)){
			//we remove the first visited flow elements of this ordered list of 
			//visited lements in order to have those who effectively are part of the loop
			int index = visited.indexOf(fe);
			List<FlowElement> l = visited.subList(index, visited.size());

			loops.add(l);
		}
		else{
			List<FlowElement> l = new ArrayList<FlowElement>(visited);
			l.add(fe);

			if(fe instanceof FlowNode){
				FlowNode fn = ((FlowNode)fe);
				if(fn.getOutgoing()!=null){
					for(FlowElement next : fn.getOutgoingFlowNodes()){
						followPath(next, l, loops);
					}
				}
			}

		}
	}


	public static PartnerLink findPartnerLinkFromInterface(QName itf,
			BPELProcess process, Set<PartnerLinkType> plts) 
					throws BPELException {
		List<PartnerLinkType> validPLT = new ArrayList<PartnerLinkType>();
		for(PartnerLinkType plt: plts) {
			for(Role r: plt.getRoles()) {
				if(r.getPortType().equals(itf)) {
					validPLT.add(plt);
				}
			}
		}

		for (PartnerLinkType plt : validPLT) {
			String pltNS = getPartnerLinkTypeNS(plt);
			for (PartnerLink pl : process.getPartnerLinks()) {
				if (pl.getPartnerLinkType().getNamespaceURI().equals(pltNS) && 
						pl.getPartnerLinkType().getLocalPart().equals(plt.getName())) {
					return pl;
				}
			}
		}
		return null;
	}

	public static String getPartnerLinkTypeNS(PartnerLinkType plt) {
		return ((com.ebmwebsourcing.easywsdl11.api.element.Definitions)plt.getXmlObjectParent()).getTargetNamespace();
	}

	public static Set<FlowNode> getAllStartingNodes(Process proc) {
		Set<FlowNode> startingNodes = new HashSet<FlowNode>();
		Set<FlowNode> alreadyVisitedNodes = new HashSet<FlowNode>();

		for(FlowNode fn : proc.getFlowNode()) {
			followPathBackWards(fn,startingNodes,alreadyVisitedNodes);
		}

		return startingNodes;
	}


	private static void followPathBackWards(FlowNode fn, Set<FlowNode> startingNodes,
			Set<FlowNode> alreadyVisitedNodes) {
		if(alreadyVisitedNodes.contains(fn)) {
			return;
		}
		else {
			List<FlowNode> incoming = fn.getIncomingFlowNodes();
			if(incoming.isEmpty()) {
				startingNodes.add(fn);
			}
			else {
				alreadyVisitedNodes.add(fn);
				for(FlowNode preceding : incoming) {
					followPathBackWards(preceding, startingNodes, alreadyVisitedNodes);
				}
			}
		}
	}

	public static String getFileNameFromImportLocation(String location) {
		int index = location.lastIndexOf("/");
		if(index!=-1) {
			if(index==location.length()-1) {
				return getFileNameFromImportLocation(location.substring(0, index));
			}
			return location.substring(index+1);
		}
		return location;
	}

	public static void addDefaultExternalParticipant(Definitions defs) {
		for(Collaboration coll : defs.getCollaborations()) {
			List<QName> referencedInterfaces = new ArrayList<QName>();

			for(Participant p : coll.getParticipant()) {
				for(QName itfRef : p.getInterfaceRef()) {
					referencedInterfaces.add(itfRef);
				}
			}

			List<QName> notReferencedInterfaces = new ArrayList<QName>();
			for(Interface itf : defs.getInterfaces()) {
				QName itfQname = new QName(itf.getId());
				if(!referencedInterfaces.contains(itfQname)) {
					notReferencedInterfaces.add(itfQname);
				}
			}

			if(!notReferencedInterfaces.isEmpty()) {
				Participant p = defs.getXmlContext().getXmlObjectFactory().create(Participant.class);
				p.setId("defaultParticipant");
				p.setName("defaultParticipant");

				for(QName itfRef : notReferencedInterfaces) {
					p.addInterfaceRef(itfRef);
				}

				coll.addParticipant(p);
			}
		}
	}

	public static String getBPELProcessName(Process bpmnProcess) {
		return (bpmnProcess.hasName() && !bpmnProcess.getName().isEmpty() ? bpmnProcess.getName().replace(" ", "") : bpmnProcess.getId());
	}
	
	private static String VARNAME_SUFFIX = "Variable";
	
	public static String getVariableName(String prefix) {
		return prefix+VARNAME_SUFFIX;
	}

	/**
	 * The send task is a reply if its operation is exposed by the participant
	 * owning its parent process
	 * @param st
	 * @return
	 * @throws BPMNException 
	 */
	public static boolean isReply(SendTask st, Participant participant, Definitions defs) throws BPMNException {
		return isOperationExposed(st.getOperationRef(), participant, defs);
	}

	public static boolean isReply(MessageEventDefinition ed, Participant participant, Definitions defs) throws BPMNException {
		return isOperationExposed(ed.getOperationRef(), participant, defs);
	}

	private static boolean isOperationExposed(QName operationRef, Participant participant, Definitions defs) throws BPMNException {
		Operation op = DefinitionsHelper.findBPMNObject(defs, operationRef, Operation.class);
		Interface itf = (Interface) op.getXmlObjectParent();

		if(participant.hasInterfaceRef()) {
			for(QName itfRef : participant.getInterfaceRef()) {
				if(itf.equals(DefinitionsHelper.findBPMNObject(defs, itfRef, Interface.class))) {
					return true;
				}
			}
		}

		return false;
	}

	public static EventDefinition getEventDefinition(WithEventDefinition wed, Definitions defs) throws BPMNException {
		if(wed.hasEventDefinition()) {
			return wed.getEventDefinition()[0];
		}
		else if(wed.hasEventDefinitionRef()) {
			return DefinitionsHelper.findBPMNObject(defs, wed.getEventDefinitionRef()[0], EventDefinition.class);
		}
		return null;
	}

}
