package com.ebmwebsourcing.easybpmn.bpmn2bpel.extension;

import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;

public abstract class AttributeExtensionAdapter {

    /**
     * @return A set or regular expressions defining the supported namespaces
     */
    public abstract Set<String> getSupportedNamespaces();
    
    protected abstract void adaptAttributeExtension(QName attQname, String attValue, WithOtherAttributes bpmnElement, BPELElement bpelElement); 
    
    public void adaptAttributeExtensions(WithOtherAttributes bpmnElt, BPELElement bpelElement) {
        Map<QName,String> attributes = bpmnElt.getOtherAttributes();
        for(QName qn : attributes.keySet()) {
            if(qn.getNamespaceURI()!=null && isNamespaceSupported(qn.getNamespaceURI())) {
                adaptAttributeExtension(qn, attributes.get(qn), bpmnElt, bpelElement);
            }
        }
    }
    
    public boolean isNamespaceSupported(String nsuri) {
        for(String regex : getSupportedNamespaces()) {
            if(nsuri.matches(regex)) {
                return true;
            }
        }
        return false;
    }
    
}
