package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;


public class WSDLGeneratorHelper {

	public static final String PLTSuffix = "PLT";
	private static Map<Interface, Definitions> definitions;
	private static XmlContext context = new XmlContextFactory().newContext();

	public static void init() {
		definitions = new HashMap<Interface, Definitions>();
	}

	public static Definitions getOrCreateDefinitions(Interface itf) {
		if(definitions.containsKey(itf)) {
			return definitions.get(itf);
		}
		Definitions res = context.getXmlObjectFactory().create(Definitions.class);
		definitions.put(itf, res);
		return res;
	}

	public static Collection<Definitions> getAllDefinitions() {
		return definitions.values();
	}

	public static String getArtefactNamespace(String targetNamespace) {
		String artefactNS = null;
		if(targetNamespace.endsWith("/")) {
			artefactNS = targetNamespace + "artefacts";
		} else {
			artefactNS = targetNamespace + "/artefacts";
		}
		return artefactNS;
	}

	public static Definitions findDefinitionsContainingInterfaceInImports(QName itfQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
		for(Import impt : bpmnDefinitions.getImports()) {
			if(impt.getNamespace().equals(itfQname.getNamespaceURI())
					&& impt.isWSDL11Import()) {
				Definitions defs = impt.getWSDL11Definitions();
				PortType pt = defs.getPortTypeByName(itfQname.getLocalPart());
				if(pt!=null){
					return defs;
				}
			}
		}
		return null;
	}
	
	public static String getPartnerLinkTypeName(Participant participant, Interface itf) {
		return participant.getName() + "_" + itf.getName() + WSDLGeneratorHelper.PLTSuffix;
	}

	public static Port findPortInImports(QName portQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
		for(Import impt : bpmnDefinitions.getImports()) {
			if(impt.getNamespace().equals(portQname.getNamespaceURI())
					&& impt.isWSDL11Import()) {
				Definitions defs = impt.getWSDL11Definitions();
				for(Service service : defs.getServices()) {
					Port port = service.getPortByName(portQname.getLocalPart());
					if(port!=null) {
						return port;
					}
				}
			}
		}
		return null;
	}
	
	public static Map<String, Schema> findImportedSchemas(Schema parent){
		Map<String, Schema> res = new HashMap<String, Schema>();
		
		Set<String> alreadyImportedSchemas = new HashSet<String>();
		res.putAll(findImportedSchemas(parent, alreadyImportedSchemas, 0));
		
		return res;
	}

	private static Map<String, Schema> findImportedSchemas(Schema parent, Set<String> alreadyImportedSchemas, int cpt){
		Map<String, Schema> res = new HashMap<String, Schema>();
		
		for(com.ebmwebsourcing.easyschema10.api.element.Import impt : parent.getImports()){
			if( ! alreadyImportedSchemas.contains(impt.getNamespace())
					&& isRelativeUrl(impt.getSchemaLocation())){
				for(XmlObjectNode child : impt.getXmlObjectAdoptedChildren()){
					
					if(child instanceof Schema){
						
						String importName = impt.getSchemaLocation().substring(impt.getSchemaLocation().lastIndexOf("/") + 1);
						if(res.containsKey(importName)){
							importName = importName + "_" + cpt++;
						}
						impt.setSchemaLocation(importName);
						res.put(importName, (Schema) child);
						alreadyImportedSchemas.add(impt.getNamespace());
						
						res.putAll(findImportedSchemas((Schema) child, alreadyImportedSchemas, cpt));
					}
				}
			}
		}
		return res;
	}
	
	private static boolean isRelativeUrl(String schemaLocation){
		try {
			new URL(schemaLocation);
		} catch (MalformedURLException e) {
			return true;
		}
		return false;
	}
}
