/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.extension;

import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.extension.AttributeExtensionAdapter;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.extension.ObjectExtensionAdapter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

public class ExtensionAdapter {
    private List<AttributeExtensionAdapter> attributeAdapters;
    private List<ObjectExtensionAdapter> objectAdapters;
    private static ExtensionAdapter instance;

    public static ExtensionAdapter getInstance() {
        if (instance == null) {
            instance = new ExtensionAdapter();
        }
        return instance;
    }

    private ExtensionAdapter() {
        ServiceLoader<Object> sl = ServiceLoader.load(AttributeExtensionAdapter.class);
        Iterator<Object> it = sl.iterator();
        this.attributeAdapters = new ArrayList<AttributeExtensionAdapter>();
        while (it.hasNext()) {
            this.attributeAdapters.add(it.next());
        }
        sl = ServiceLoader.load(ObjectExtensionAdapter.class);
        it = sl.iterator();
        this.objectAdapters = new ArrayList<ObjectExtensionAdapter>();
        while (it.hasNext()) {
            this.objectAdapters.add((ObjectExtensionAdapter)it.next());
        }
    }

    public void adaptExtensions(BaseElement bpmnElt, BPELElement bpelElt) {
        for (AttributeExtensionAdapter attAdapter : this.attributeAdapters) {
            attAdapter.adaptAttributeExtensions((WithOtherAttributes)bpmnElt, bpelElt);
        }
        for (ObjectExtensionAdapter objAdapter : this.objectAdapters) {
            objAdapter.adaptObjectExtensions(bpmnElt, bpelElt);
        }
    }
}

