/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Error;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ItemDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Message;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBaseElement;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl.WSDLGeneratorHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Fault;
import com.ebmwebsourcing.easywsdl11.api.element.Input;
import com.ebmwebsourcing.easywsdl11.api.element.Operation;
import com.ebmwebsourcing.easywsdl11.api.element.Output;
import com.ebmwebsourcing.easywsdl11.api.element.Part;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Types;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class AbstractWSDLGenerator {
    public static Definitions generateAbstractWSDL(Interface itfM, GenerationProperties gp) throws BPMNException {
        boolean found = false;
        HashSet<Element> elmtToImports = new HashSet<Element>();
        Definitions res = WSDLGeneratorHelper.getOrCreateDefinitions(itfM);
        Types types = null;
        if (res.hasTypes()) {
            types = res.getTypes();
        } else {
            types = gp.newInstance(Types.class);
            res.setTypes(types);
        }
        if (itfM.hasImplementationRef()) {
            QName implemRef = itfM.getImplementationRef();
            for (Import import_ : DefinitionsHelper.getParentDefinitions((TBaseElement)itfM).getImports()) {
                Definitions defs;
                PortType pt;
                if (!import_.getNamespace().equals(implemRef.getNamespaceURI()) || !import_.isWSDL11Import() || (pt = (defs = import_.getWSDL11Definitions()).getPortTypeByName(implemRef.getLocalPart())) == null) continue;
                found = true;
                res.setTargetNamespace(implemRef.getNamespaceURI());
                AbstractWSDLGenerator.addPortTypeAndRelatedMessages(pt, defs, res);
                elmtToImports.addAll(AbstractWSDLGenerator.findElementToImport(pt, defs));
                break;
            }
        }
        if (!found) {
            res.setTargetNamespace(gp.getBPMNDefinitions().getTargetNamespace());
            AbstractWSDLGenerator.addPortType(AbstractWSDLGenerator.createPortType(itfM, res, elmtToImports, gp), res);
        }
        res.setName(itfM.getName().replace(" ", ""));
        ArrayList<String> alreadyImportedSchema = new ArrayList<String>();
        for (Import import_ : (Schema[])types.getAnyXmlObjects(Schema.class)) {
            alreadyImportedSchema.add(import_.getTargetNamespace());
        }
        for (Element elmt : elmtToImports) {
            Schema model = SchemaHelper.findParentSchema((XmlObject)elmt);
            if (alreadyImportedSchema.contains(model.getTargetNamespace())) continue;
            types.addAnyXmlObject((XmlObject)model);
            alreadyImportedSchema.add(model.getTargetNamespace());
        }
        return res;
    }

    private static void addPortTypeAndRelatedMessages(PortType pt, Definitions readDefs, Definitions resultDefs) {
        for (Operation op : pt.getOperations()) {
            if (op.hasInput()) {
                AbstractWSDLGenerator.addMessage(readDefs.getMessageByName(op.getInput().getMessage().getLocalPart()), resultDefs);
            }
            if (op.hasOutput()) {
                AbstractWSDLGenerator.addMessage(readDefs.getMessageByName(op.getOutput().getMessage().getLocalPart()), resultDefs);
            }
            if (op.getFaults() == null) continue;
            for (Fault f : op.getFaults()) {
                AbstractWSDLGenerator.addMessage(readDefs.getMessageByName(f.getMessage().getLocalPart()), resultDefs);
            }
        }
        AbstractWSDLGenerator.addPortType(pt, resultDefs);
    }

    private static void addPortType(PortType pt, Definitions defs) {
        if (defs.getPortTypeByName(pt.getName()) == null) {
            defs.addPortType(pt);
        }
    }

    private static void addMessage(com.ebmwebsourcing.easywsdl11.api.element.Message m, Definitions defs) {
        if (defs.getMessageByName(m.getName()) == null) {
            defs.addMessage(m);
        }
    }

    private static Set<Element> findElementToImport(PortType pt, Definitions defs) {
        HashSet<Element> res = new HashSet<Element>();
        for (Operation op : pt.getOperations()) {
            if (op.hasInput()) {
                res.addAll(AbstractWSDLGenerator.findMessageElements(op.getInput().getMessage().getLocalPart(), defs));
            }
            if (op.hasOutput()) {
                res.addAll(AbstractWSDLGenerator.findMessageElements(op.getOutput().getMessage().getLocalPart(), defs));
            }
            for (Fault f : op.getFaults()) {
                res.addAll(AbstractWSDLGenerator.findMessageElements(f.getMessage().getLocalPart(), defs));
            }
        }
        return res;
    }

    private static Set<Element> findMessageElements(String msgName, Definitions defs) {
        HashSet<Element> res = new HashSet<Element>();
        com.ebmwebsourcing.easywsdl11.api.element.Message msg = defs.getMessageByName(msgName);
        for (Part part : msg.getParts()) {
            res.add(SchemaHelper.findElementByQName((XmlObject)defs, (QName)part.getElement()));
        }
        return res;
    }

    private static PortType createPortType(Interface itfM, Definitions res, Set<Element> elmtToImports, GenerationProperties gp) throws BPMNException {
        PortType itfT = gp.newInstance(PortType.class);
        itfT.setName(itfM.getName());
        for (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation opM : itfM.getOperations()) {
            com.ebmwebsourcing.easywsdl11.api.element.Message message;
            Operation op = gp.newInstance(Operation.class);
            itfT.addOperation(op);
            if (gp.getBPMNDefinitions() != null && opM.getName() != null) {
                op.setName(opM.getName());
            }
            if (opM.hasInMessageRef()) {
                Input input = gp.newInstance(Input.class);
                message = AbstractWSDLGenerator.createOrFindMessage(opM.getInMessageRef().getLocalPart(), res, gp, elmtToImports);
                input.setName(message.getName());
                input.setMessage(new QName(res.getTargetNamespace(), message.getName()));
                op.setInput(input);
            }
            if (opM.hasOutMessageRef()) {
                Output output = gp.newInstance(Output.class);
                message = AbstractWSDLGenerator.createOrFindMessage(opM.getOutMessageRef().getLocalPart(), res, gp, elmtToImports);
                output.setName(message.getName());
                output.setMessage(new QName(res.getTargetNamespace(), message.getName()));
                op.setOutput(output);
            }
            if (!opM.hasErrorRef()) continue;
            for (QName errorRef : opM.getErrorRef()) {
                Fault fault = gp.newInstance(Fault.class);
                for (Error error : gp.getBPMNDefinitions().getErrors()) {
                    if (!error.getId().equals(errorRef.getLocalPart())) continue;
                    com.ebmwebsourcing.easywsdl11.api.element.Message message2 = res.getMessageByName(error.getName());
                    fault.setName(error.getName());
                    if (message2 == null) {
                        message2 = gp.newInstance(com.ebmwebsourcing.easywsdl11.api.element.Message.class);
                        message2.setName(error.getName());
                        for (ItemDefinition item : gp.getBPMNDefinitions().getItemDefinitions()) {
                            if (!item.getId().equals(error.getStructureRef())) continue;
                            Part part = gp.newInstance(Part.class);
                            part.setElement(item.getStructureRef());
                            message2.addPart(part);
                            elmtToImports.add(gp.getBPMNDefinitions().findImportedElement(item.getStructureRef()));
                            break;
                        }
                        AbstractWSDLGenerator.addMessage(message2, res);
                    }
                    fault.setMessage(new QName(res.getTargetNamespace(), message2.getName()));
                    break;
                }
                op.addFault(fault);
            }
        }
        return itfT;
    }

    private static com.ebmwebsourcing.easywsdl11.api.element.Message createOrFindMessage(String msgId, Definitions defs, GenerationProperties gp, Set<Element> elmtToImports) throws BPMNException {
        for (Message msg : gp.getBPMNDefinitions().getMessages()) {
            if (!msg.getId().equals(msgId)) continue;
            com.ebmwebsourcing.easywsdl11.api.element.Message message = defs.getMessageByName(msg.getName());
            if (message == null) {
                message = AbstractWSDLGenerator.buildMessage(msg, gp, elmtToImports);
                AbstractWSDLGenerator.addMessage(message, defs);
            }
            return message;
        }
        return null;
    }

    private static com.ebmwebsourcing.easywsdl11.api.element.Message buildMessage(Message msg, GenerationProperties gp, Set<Element> elmtToImports) throws BPMNException {
        com.ebmwebsourcing.easywsdl11.api.element.Message message = gp.newInstance(com.ebmwebsourcing.easywsdl11.api.element.Message.class);
        message.setName(msg.getName());
        for (ItemDefinition item : gp.getBPMNDefinitions().getItemDefinitions()) {
            if (!item.getId().equals(msg.getItemRef().getLocalPart())) continue;
            Part part = gp.newInstance(Part.class);
            part.setElement(item.getStructureRef());
            message.addPart(part);
            Element elt = gp.getBPMNDefinitions().findImportedElement(item.getStructureRef());
            elmtToImports.add(elt);
            part.setName(elt.getName());
            break;
        }
        return message;
    }
}

