package com.ebmwebsourcing.easybpmn.bpmn2bpel.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;

public class ExtensionAdapter {

    private List<AttributeExtensionAdapter> attributeAdapters;
    private List<ObjectExtensionAdapter> objectAdapters;
    
    private static ExtensionAdapter instance;
    
    public static ExtensionAdapter getInstance() {
        if(instance==null) {
            instance = new ExtensionAdapter();
        }
        return instance;
    }
    
    private ExtensionAdapter(){
        {
            ServiceLoader<AttributeExtensionAdapter> sl = ServiceLoader.load(AttributeExtensionAdapter.class);
            Iterator<AttributeExtensionAdapter> it = sl.iterator();
            attributeAdapters = new ArrayList<AttributeExtensionAdapter>();
            while(it.hasNext()){
                attributeAdapters.add(it.next());
            }
        }
        {
            ServiceLoader<ObjectExtensionAdapter> sl = ServiceLoader.load(ObjectExtensionAdapter.class);
            Iterator<ObjectExtensionAdapter> it = sl.iterator();
            objectAdapters = new ArrayList<ObjectExtensionAdapter>();
            while(it.hasNext()){
                objectAdapters.add(it.next());
            }
        }
    }
    
    public void adaptExtensions(BaseElement bpmnElt, BPELElement bpelElt) {
        for(AttributeExtensionAdapter attAdapter : attributeAdapters) {
            attAdapter.adaptAttributeExtensions(bpmnElt, bpelElt);
        }
        for(ObjectExtensionAdapter objAdapter : objectAdapters) {
            objAdapter.adaptObjectExtensions(bpmnElt, bpelElt);
        }
    }
    
}
