package com.ebmwebsourcing.easybpmn.bpmn2bpel.extension;

import java.util.List;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.BaseElement;

public abstract class ObjectExtensionAdapter {
    
    public abstract List<Class<? extends XmlObject>> getSupportedXmlObjects();
    
    protected abstract void adaptObjectExtension(XmlObject extension, BaseElement bpmnElt, BPELElement bpelElement);
    
    public void adaptObjectExtensions(BaseElement bpmnElt, BPELElement bpelElement) {
        if(bpmnElt.hasExtensionElements()) {
            for(XmlObject xo : bpmnElt.getExtensionElements().getAnyXmlObjects()) {
                if(supportsXmlObject(xo.getClass())) {
                    adaptObjectExtension(xo, bpmnElt, bpelElement);
                }
            }
        }
    }
    
    public boolean supportsXmlObject(Class<? extends XmlObject> c){
        for(Class<? extends XmlObject> clazz : getSupportedXmlObjects()){
            if(clazz.isAssignableFrom(c)){
                return true;
            }
        }
        return false;
    }
    
}
