
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EndPoint;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easywsdl11.api.WsdlHelper;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.Service;

public class ConcreteWSDLGenerator {

    
    public static void generateConcreteWSDL(Interface itf, Participant participant,
            Definitions abstractDesc, GenerationProperties gp) throws BPMNException {
        
        if (itf.hasImplementationRef()) {

            //always a unique service with possibly multiple ports
            Service s = null;
            if(abstractDesc.getServices()==null || abstractDesc.getServices().length==0) {
                s = gp.newInstance(Service.class);
                s.setName(abstractDesc.getName() + "Service");
            }
            else {
                s = abstractDesc.getServices()[0];
            }
            
            Map<String,Port> ports = new HashMap<String,Port>();

            // search for the BPMN endpoint
            // if it exists find the corresponding port in the imported wsdls
            // check that its binding refers to the correct portype
            // finally add the port and the binding to the service
            if (participant!=null && participant.hasEndPointRef()) {
                for (QName qn : participant.getEndPointRef()) {
                    EndPoint endpoint = DefinitionsHelper.findBPMNObject(gp
                            .getBPMNDefinitions(), qn, EndPoint.class);
                    if (endpoint != null && endpoint.hasEndPointRef()) {
                        Port p = WSDLGeneratorHelper.findPortInImports(endpoint.getEndPointRef(),
                                gp.getBPMNDefinitions());
                        Binding binding = WsdlHelper.findParentDefinitions(p).getBindingByName(
                                p.getBinding().getLocalPart());
                        if (binding.getType().equals(itf.getImplementationRef())) {
                            if(abstractDesc.getBindingByName(binding.getName())==null) {
                                abstractDesc.addBinding(binding);
                            }
                            if(!ports.containsKey(p.getName())) {
                                ports.put(p.getName(),p);
                            }
                        }
                    }
                }
            }

            // if no bpmn endpoint exists, search for wsdl endpoints having a
            // binding for this port type
            if(ports.isEmpty()) {
                QName implemRef = itf.getImplementationRef();
                Definitions defs = WSDLGeneratorHelper.findDefinitionsContainingInterfaceInImports(implemRef, gp.getBPMNDefinitions());
                if(defs!=null) {
                    List<String> bindings = new ArrayList<String>();
                    for (Binding binding : defs.getBindings()) {
                        if (binding.hasType() && binding.getType().equals(implemRef)) {
                            bindings.add(binding.getName());
                        }
                    }

                    for (Service service : defs.getServices()) {
                        for (Port port : service.getPorts()) {
                            if (bindings.contains(port.getBinding().getLocalPart())) {
                                if(!ports.containsKey(port.getName())) {
                                    ports.put(port.getName(),port);
                                }
                                Binding binding = defs.getBindingByName(port.getBinding().getLocalPart()); 
                                if(abstractDesc.getBindingByName(binding.getName())==null) {
                                    abstractDesc.addBinding(binding);
                                }
                            }
                        }
                    }
                }
            }

            // if no endpoint can be found for the portype do not build a
            // concrete wsdl

            // finally add the service if it has been created (even if it is empty) 
            if(abstractDesc.getServiceByName(s.getName())==null) { 
                abstractDesc.addService(s);
                for(Port p : ports.values()) {
                    s.addPort(p);
                }
            }
        }
        
    }
    
    
}
