
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.PartnerRole;
import com.ebmwebsourcing.easybpmn.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

public class PartnerLinkTypeGenerator {

    
    public static void generatePartnerLinkType(Interface itf, Participant participant, Definitions defs, GenerationProperties gp) throws BPMNException {
        PartnerLinkType plt = gp.newInstance(PartnerLinkType.class);
        gp.getPartnerLinkTypes().put(plt, participant);
        defs.addAnyXmlObject(plt);
        Role role = gp.newInstance(Role.class);
        plt.addRole(role);

        plt.setName(WSDLGeneratorHelper.getPartnerLinkTypeName(participant, itf));
        if (itf.hasImplementationRef()) {
            role.setPortType(itf.getImplementationRef());
        } else {
            role.setPortType(new QName(gp.getBPMNDefinitions().getTargetNamespace(), itf
                    .getName()));
        }

        role.setName(itf.getName());
        firstLoop:
        for (PartnerRole pr : gp.getBPMNDefinitions().getPartnerRoles()) {
            if (pr.hasParticipantRef()) {
                for (QName participantQname : pr.getParticipantRef()) {
                    if (participantQname.getLocalPart().equals(participant.getId())) {
                        role.setName(pr.getName());
                        break firstLoop;
                    }
                }
            }
        }
    }

}
