package com.ebmwebsourcing.easycommons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipHelper {

	/**
	 * Extract all the archive entries with a name starting with the specified
	 * name prefix to the specified destination directory
	 * 
	 * @param archive
	 *            the archive which contains the entries to extract
	 * @param entryNamePrefix
	 *            the name prefix of entries to extract from the archive
	 * @param absoluteDestDir
	 *            the directory to extract the archive entries
	 * @throws IOException
	 *             if an I/O entry has occurred
	 */
	public static void extractEntriesFromArchive(ZipFile archive, String entryNamePrefix, File destDir) throws IOException {
		assert archive != null;
		assert entryNamePrefix != null;
		assert destDir != null && destDir.isDirectory();
    	
    	Enumeration<? extends ZipEntry> entries = archive.entries();
    	while(entries.hasMoreElements()) {
    		ZipEntry entry = entries.nextElement();
        	String entryName = entry.getName();
    		if(entryName.startsWith(entryNamePrefix)) {
    			if(entry.isDirectory()) {
					File extractedFile = new File(destDir, entryName);
					extractedFile.mkdirs();
    			} else {
	            	InputStream inputStream = archive.getInputStream(entry);
					File extractedFile = new File(destDir, entryName);
					extractedFile.getParentFile().mkdirs();
					FileOutputStream fileOutputStream = new FileOutputStream(extractedFile);
	            	byte[] buffer = new byte[2048];
	            	int length = inputStream.read(buffer); 
	            	while(length > 0) {
	            		fileOutputStream.write(buffer, 0, length);
	                	length = inputStream.read(buffer); 
	            	}
    			}
    		}
    	}
		
	}


}
