/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.logger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author aruffie
 * Class util which provide several helping methods
 */
public final class LoggerHelper {

    private LoggerHelper() {
    }
    
    /**
     * Get the level of a logger or the level owned by its parent.
     * @param logger a logger
     * @return the level of the logger or the level owned by its parent.
     */
    public static final Level getLevelOrParentLevel (final Logger logger) {
        assert logger != null;
        Level level = logger.getLevel();
        if(level == null) {
            assert logger.getParent() != null;
            level = getLevelOrParentLevel(logger.getParent());
        }
        return level;
    }
    
    /**
     * Get the handlers of a logger and the handlers owned by its parent if
     * it sends its output to its parent
     * @param logger a logger
     * @return the list of handlers of a logger and the handlers owned by its parent if
     * it sends its output to its parent
     */
    public static final List<Handler> getHandlersOrParentHanders(final Logger logger) {
        List<Handler> handlers = new ArrayList<Handler>(Arrays.asList(logger.getHandlers()));
        if(logger.getUseParentHandlers() && logger.getParent() != null) {
            handlers.addAll(getHandlersOrParentHanders(logger.getParent()));
        }
        return handlers;
    }
}
