/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/
 
package com.ebmwebsourcing.easycommons.logger;

/**
 * Class allowing to define specific <Level> in addition to JDK logging levels.
 * 
 * @author mjambert, aruffie
 * 
 */
public final class Level extends java.util.logging.Level {

    private static final long serialVersionUID = -5961140360420071107L;

    public static final java.util.logging.Level MONIT = new Level("MONIT", 600);

    public static final java.util.logging.Level MONIT_MSG = new Level("MONIT-MSG", 550);

    protected Level(String name, int value) {
        super(name, value);
    }

    /**
     * Allow to return all JDK logging <Level> and specific logging <Level>.
     * 
     * @return All <Level> as an array in decreasing order.
     */
    public static final java.util.logging.Level[] getLevels() {
        return new java.util.logging.Level[] { OFF, SEVERE, WARNING, INFO, CONFIG, MONIT, MONIT_MSG, FINE,
                FINER, FINEST, ALL };
    }

    /**
     * This empty method must be called before any use of a custom Level. Custom
     * Level constructor add custom Levels to known Levels registered in
     * {@link java.util.logging.Level} class.
     */
    public static void initialize() {
    }

}
