package com.ebmwebsourcing.easycommons.sca.helper.impl;

import java.util.List;

import org.objectweb.fractal.api.Component;
import org.ow2.frascati.tinfi.TinfiDomain;
import org.ow2.frascati.tinfi.api.IntentHandler;
import org.ow2.frascati.tinfi.api.control.SCAIntentController;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;


public class SCAIntentHelper {

	private static SCAIntentHelper intentHelper = new SCAIntentHelper();


	private SCAIntentHelper(){
		super();
	}

	public static SCAIntentHelper getSCAIntentHelper(){
		return SCAIntentHelper.intentHelper;
	}

	
	
	public void injectIntentIntoComponents(String intenthandler, List<Component> comps) throws SCAException{
		for(Component comp : comps){
			injectIntentIntoComponent(intenthandler, comp);
		}
	}
	
	public void injectIntentIntoComponent(String intenthandler, Component comp) throws SCAException{

		String adl = intenthandler+"Factory";

		try {
			IntentHandler intent = TinfiDomain.getService(adl, IntentHandler.class,"service");
			SCAIntentController ic = (SCAIntentController) comp.getFcInterface(SCAIntentController.NAME);

			boolean wasStarted = false;
			if(SCAHelper.getSCAHelper().isStarted(comp)){
				SCAHelper.getSCAHelper().stopComponent(comp);
				wasStarted = true;
			}

			ic.addFcIntentHandler(intent);


			if(wasStarted){
				SCAHelper.getSCAHelper().startComponent(comp);
			}

		} catch (Exception e) {
			e.printStackTrace();
			throw new SCAException(e.getMessage());
		}		
	}

	
	
	public void releaseIntentInComponents(IntentHandler intent, List<Component> comps) throws SCAException{
		
		for(Component comp : comps){
			releaseIntentInComponent(intent, comp);
		}
	}
	
	
	public void releaseIntentInComponent(IntentHandler intent, Component comp) throws SCAException{

		SCAIntentController ic;
		try {
			ic = (SCAIntentController) comp.getFcInterface(SCAIntentController.NAME);


			boolean wasStarted = false;
			if(SCAHelper.getSCAHelper().isStarted(comp)){
				SCAHelper.getSCAHelper().stopComponent(comp);
				wasStarted = true;
			}

			ic.removeFcIntentHandler(intent);


			if(wasStarted){
				SCAHelper.getSCAHelper().startComponent(comp);
			}

		} catch (Exception e){
			e.printStackTrace();
			throw new SCAException(e.getMessage());
		}
	}
}