/**

 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 Consortium, http://www.ow2.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easycommons.thread;

import java.util.Properties;

public final class ExecutionContext {

    private static final InheritableThreadLocal<Properties> itl;

    static {
        itl = new InheritableThreadLocal<Properties>() {
            protected Properties initialValue() {
                return new Properties();
            }
            
            @Override
            protected Properties childValue(Properties parentValue) {
                return new Properties(parentValue);
            }
        };
    }

    private ExecutionContext() {
    }
    
    public static final Properties getProperties() {
        return itl.get();
    }
}
