package com.ebmwebsourcing.easycommons.uri;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIHelper {

	public static URI filePathToUri(String path) {
		URI uri;
		try {
			path = path.replaceAll("\\\\", "/");
			uri = new URI(path);
		} catch (URISyntaxException e1) {
			uri = new File(path).toURI();
			uri.normalize();
		}
		return uri;
	}

	public static URI resolve(URI baseURI, String systemId)
			throws MalformedURLException, URISyntaxException {
		URI res = null;
		if (baseURI == null) {
			if (systemId == null) {
				return null;
			}
			return URI.create(systemId);
		}
		if ("jar".equals(baseURI.getScheme())) {
			res = new URL(baseURI.toURL(), systemId).toURI();
		} else if(baseURI.isAbsolute()){
			res = baseURI.resolve(systemId);
		}

		return res;
	}
}
