
package com.ebmwebsourcing.easycommons.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.xml.XMLConstants;

import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

public final class XMLComparator {

    private XMLComparator() {
    }

    public static boolean isEquivalent(String s1, String s2) {
        return isEquivalent(new ByteArrayInputStream(s1.getBytes()),
                new ByteArrayInputStream(s2.getBytes()));
    }

    public static boolean isEquivalent(InputStream is1, InputStream is2) {
        try {
            XMLUnit.setIgnoreAttributeOrder(true);
            XMLUnit.setIgnoreWhitespace(true);

            Diff diff = XMLUnit.compareXML(new InputStreamReader(is1), new InputStreamReader(is2));
            diff.overrideDifferenceListener(new IgnoreIrrelevantNodesDifferenceListener() {

                @Override
                protected boolean isIrrelevantChildNode(Node node) {
                    return false;
                }

                @Override
                protected boolean isIrrelevantAttribute(Attr att) {
                    return (XMLConstants.XMLNS_ATTRIBUTE_NS_URI.equals(att.getNamespaceURI()))
                            || (XMLConstants.W3C_XML_SCHEMA_INSTANCE_NS_URI.equals(att
                                    .getNamespaceURI()));
                }
            });

            if (!diff.identical()) {
                System.err.println(new DetailedDiff(diff));
            }
            return diff.identical();
        } catch (SAXException se) {
            throw new UncheckedException(se);
        } catch (IOException ioe) {
            throw new UncheckedException(ioe);
        }
    }

}
