package com.ebmwebsourcing.easycommons.xml.resolver;

import java.util.ArrayList;
import java.util.List;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;

public class URIMultipleResolvers implements URIResolver {


	private List<URIResolver> resolvers = new ArrayList<URIResolver>();	

	public URIMultipleResolvers() {
		this(new DefaultURIResolver(), new ClasspathURIResolver());
	}
	
	public URIMultipleResolvers(URIResolver... resolvers) {
		for(URIResolver resolver: resolvers) {
			this.resolvers.add(resolver);
		}
	}


	@Override
	public Source resolve(String href, String base) throws TransformerException {
		Source res = null;
		
		for(URIResolver resolver: this.resolvers) {
			try {
				res = resolver.resolve(href, base);
				if(res != null) {
					break;
				}
			} catch(TransformerException e) {
				// do nothing
			}
		}

		
		return res;
	}
	
	public URIResolver[] getURIResolvers() {
		return this.resolvers.toArray(new URIResolver[this.resolvers.size()]);
	}
}
