/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.pooling;

import com.ebmwebsourcing.easycommons.pooling.GenericResourcePool;
import com.ebmwebsourcing.easycommons.pooling.PoolException;
import com.ebmwebsourcing.easycommons.pooling.PoolPolicy;
import com.ebmwebsourcing.easycommons.pooling.ResourceHandler;
import com.ebmwebsourcing.easycommons.thread.SimultaneousTaskExecutor;
import com.ebmwebsourcing.easycommons.thread.TestThread;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class GenericResourcePoolTest {
    @Test
    public void testGenericResourcePoolInstantiation() {
        new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 10, 15, PoolPolicy.WAIT);
    }

    @Test
    public void testGenericResourcePoolTake() {
        GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 10, 15, PoolPolicy.WAIT);
        String str = (String)pool.take();
        if (str == null) {
            Assert.fail((String)"A string must be created and returned by the pool");
        }
    }

    @Test
    public void testGenericResourcePoolRelease() {
        GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 10, 15, PoolPolicy.WAIT);
        String str = (String)pool.take();
        if (str == null) {
            Assert.fail((String)"A string must be created and returned by the pool");
        }
        pool.release((Object)str);
    }

    @Test(expected=PoolException.class, timeout=300000L)
    public void testGenericResourcePoolMaxReachedSize() {
        GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 3, 3, PoolPolicy.WAIT);
        pool.take();
        pool.take();
        pool.take();
        final Thread mainThread = Thread.currentThread();
        Thread interrupter = new Thread(new Runnable(){

            @Override
            public void run() {
                while (mainThread.getState() != Thread.State.WAITING) {
                    Thread.yield();
                }
                mainThread.interrupt();
            }
        });
        interrupter.start();
        pool.take();
    }

    @Test(timeout=30000L)
    public void testGenericResourcePoolDynamicPart() throws Exception {
        final GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 1, 5, PoolPolicy.WAIT);
        final Semaphore sem = new Semaphore(0);
        String str1 = (String)pool.take();
        Assert.assertEquals((Object)"test1", (Object)str1);
        String str2 = (String)pool.take();
        Assert.assertEquals((Object)"test2", (Object)str2);
        final String str3 = (String)pool.take();
        Assert.assertEquals((Object)"test3", (Object)str3);
        String str4 = (String)pool.take();
        Assert.assertEquals((Object)"test4", (Object)str4);
        String str5 = (String)pool.take();
        Assert.assertEquals((Object)"test5", (Object)str5);
        final Thread mainThread = Thread.currentThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (mainThread.getState() != Thread.State.WAITING) {
                    Thread.yield();
                }
                pool.release((Object)str3);
                try {
                    sem.acquire();
                    String str = (String)pool.take();
                    Assert.assertEquals((Object)"test5", (Object)str);
                }
                catch (InterruptedException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        TestThread releaseThread = new TestThread(runnable);
        releaseThread.start();
        String str = (String)pool.take();
        Assert.assertEquals((Object)"test3", (Object)str);
        sem.release();
        pool.release((Object)str5);
        releaseThread.joinExplosively();
    }

    @Test(timeout=30000L)
    public void testGenericResourcePoolMaxWithMultipleThreads() throws Exception {
        int poolMaxSize = 50;
        final GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 2, 50, PoolPolicy.WAIT);
        final AtomicInteger threadWithAResource = new AtomicInteger(0);
        SimultaneousTaskExecutor ste = new SimultaneousTaskExecutor();
        int threadNb = 50;
        for (int i = 0; i < 50; ++i) {
            ste.registerTask(new Runnable(){

                @Override
                public void run() {
                    pool.take();
                    threadWithAResource.incrementAndGet();
                }
            });
        }
        ste.executeAllRegisteredTasks();
        Assert.assertTrue((threadWithAResource.intValue() == 50 ? 1 : 0) != 0);
    }

    @Test(timeout=30000L)
    public void testGenericResourcePoolMaxWithMultipleThreads2() throws Exception {
        int poolMaxSize = 3;
        final GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 2, 3, PoolPolicy.WAIT);
        final AtomicInteger threadWithAResource = new AtomicInteger(0);
        SimultaneousTaskExecutor ste = new SimultaneousTaskExecutor();
        int threadNb = 5;
        for (int i = 0; i < 5; ++i) {
            ste.registerTask(new Runnable(){

                @Override
                public void run() {
                    String str = (String)pool.take();
                    threadWithAResource.incrementAndGet();
                    Assert.assertTrue((threadWithAResource.intValue() <= 3 ? 1 : 0) != 0);
                    threadWithAResource.decrementAndGet();
                    pool.release((Object)str);
                }
            });
        }
        ste.executeAllRegisteredTasks();
    }

    @Test(expected=PoolException.class)
    public void testGenericResourcePoolWithRejectPoolPolicy() {
        GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 3, 3, PoolPolicy.REJECT);
        pool.take();
        pool.take();
        pool.take();
        pool.take();
    }

    @Test(timeout=30000L)
    public void testConcurrentTakeRelease() throws Exception {
        final GenericResourcePool pool = new GenericResourcePool((ResourceHandler)new StringResourceHandler(), 1, 1, PoolPolicy.WAIT);
        String str = (String)pool.take();
        Assert.assertEquals((Object)"test1", (Object)str);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String str = (String)pool.take();
                    Assert.assertEquals((Object)"test1", (Object)str);
                }
                catch (PoolException e) {
                    Assert.fail((String)e.getMessage());
                }
            }
        };
        TestThread takeThread = new TestThread(runnable);
        takeThread.start();
        while (takeThread.getState() != Thread.State.WAITING) {
            Thread.yield();
        }
        pool.release((Object)str);
        takeThread.joinExplosively();
    }

    @Test(timeout=30000L)
    public void testOnTakeAndOnReleaseMethod() throws Exception {
        StringResourceHandlerWithOnTakeAndOnReleaseImpl ressourceHandler = new StringResourceHandlerWithOnTakeAndOnReleaseImpl();
        GenericResourcePool pool = new GenericResourcePool((ResourceHandler)ressourceHandler, 1, 1, PoolPolicy.WAIT);
        Assert.assertTrue((!ressourceHandler.isOnTake() ? 1 : 0) != 0);
        Assert.assertTrue((!ressourceHandler.isOnRelease() ? 1 : 0) != 0);
        String str = (String)pool.take();
        Assert.assertTrue((boolean)ressourceHandler.isOnTake());
        Assert.assertTrue((!ressourceHandler.isOnRelease() ? 1 : 0) != 0);
        pool.release((Object)str);
        Assert.assertTrue((boolean)ressourceHandler.isOnTake());
        Assert.assertTrue((boolean)ressourceHandler.isOnRelease());
    }

    private class StringResourceHandlerWithOnTakeAndOnReleaseImpl
    implements ResourceHandler<String> {
        public boolean onTake = false;
        public boolean onRelease = false;

        public boolean isOnTake() {
            return this.onTake;
        }

        public boolean isOnRelease() {
            return this.onRelease;
        }

        public String create() {
            return new String("test");
        }

        public void onTake(String resource) {
            this.onTake = true;
        }

        public void onRelease(String resource) {
            this.onRelease = true;
        }
    }

    private class StringResourceHandler
    implements ResourceHandler<String> {
        public int count = 0;

        public String create() {
            ++this.count;
            return new String("test" + this.count);
        }

        public void onTake(String resource) {
        }

        public void onRelease(String resource) {
        }
    }
}

