/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 OW2 Consortium, http://www.ow2.org/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easycommons.pooling;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

/**
 * General pool exception.
 *         
 * @see GenericResourcePool
 * 
 * @author aruffie 
 * @author noddoux
 */
public class PoolException extends UncheckedException {

    private static final long serialVersionUID = 5337876521563081165L;

    /**
     * Create a pool exception
     * 
     * @param message the message for the exception
     */
    public PoolException(final String message) {
        super(message);
    }

    /**
     * Create a pool exception
     * 
     * @param cause the cause of the exception
     */
    public PoolException(final Throwable cause) {
        super(cause);
    }

    /**
     * Create a pool exception
     * 
     * @param message the message for the exception
     * @param cause the cause of the exception
     */
    public PoolException(final String message, final Throwable cause) {
        super(message, cause);
    }

}
