/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.test;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Assert;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Parameterized;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public final class ParameterizedSuite
extends Suite {
    private static Logger LOG = Logger.getLogger(ParameterizedSuite.class.getName());
    private final List<Runner> runners = new ArrayList<Runner>();

    public ParameterizedSuite(Class<?> klass) throws Exception {
        this(klass, ParameterizedSuite.getAnnotatedClasses(klass));
    }

    protected ParameterizedSuite(Class<?> klass, Class<?>[] annotatedClasses) throws Exception {
        super(klass, new Class[0]);
        List<Object[]> parametersList = null;
        try {
            parametersList = this.getParametersList();
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
            LOG.log(Level.SEVERE, "Error while initializing ParameterizedSuite.", th);
            Assert.fail((String)th.getMessage());
        }
        for (int i = 0; i < parametersList.size(); ++i) {
            if (!(parametersList.get(i) instanceof Object[])) {
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), this.getParametersMethod().getName()));
            }
            for (Class<?> clazz : annotatedClasses) {
                try {
                    this.runners.add((Runner)new TestClassRunnerForParameters(clazz, this.getParametersList(), i));
                }
                catch (Throwable th) {
                    LOG.log(Level.SEVERE, "Error while initializing ParameterizedSuite.", th);
                    Assert.fail((String)(th.getMessage() + " for " + clazz.getName()));
                }
            }
        }
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Object[]> getParametersList() throws Throwable {
        return (List)this.getParametersMethod().invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getParametersMethod() throws Exception {
        List methods = this.getTestClass().getAnnotatedMethods(Parameterized.Parameters.class);
        for (FrameworkMethod each : methods) {
            int modifiers = each.getMethod().getModifiers();
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            return each;
        }
        throw new Exception("No public static parameters method on class " + this.getTestClass().getName());
    }

    private static Class<?>[] getAnnotatedClasses(Class<?> klass) throws InitializationError {
        Suite.SuiteClasses annotation = klass.getAnnotation(Suite.SuiteClasses.class);
        if (annotation == null) {
            throw new InitializationError(String.format("class '%s' must have a SuiteClasses annotation", klass.getName()));
        }
        return annotation.value();
    }

    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private static final String RUNNER_NAME_FORMAT_STRING = "%s [%s]";
        private static final String TEST_NAME_FORMAT_STRING = " %s [%s]";
        private final List<Object[]> parameterList;
        private final int parameterSetNumber;

        TestClassRunnerForParameters(Class<?> type, List<Object[]> parameterList, int i) throws InitializationError {
            super(type);
            this.parameterList = parameterList;
            this.parameterSetNumber = i;
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }

        private Object[] computeParams() throws Exception {
            try {
                return this.parameterList.get(this.parameterSetNumber);
            }
            catch (ClassCastException e) {
                throw new Exception(String.format(this.getTestClass().getName(), ParameterizedSuite.this.getParametersMethod().getName()));
            }
        }

        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
        }

        protected String getName() {
            return String.format(RUNNER_NAME_FORMAT_STRING, this.getTestClass().getJavaClass().getSimpleName(), this.getParametersName());
        }

        private String getParametersName() {
            String testName = String.valueOf(this.parameterSetNumber);
            Object[] parameters = this.parameterList.get(this.parameterSetNumber);
            if (parameters.length > 0) {
                testName = String.valueOf(parameters[0]);
            }
            return testName;
        }

        protected String testName(FrameworkMethod method) {
            return String.format(TEST_NAME_FORMAT_STRING, method.getName(), this.getParametersName());
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }
    }
}

