/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.uuid;

import com.eaio.uuid.UUID;
import com.ebmwebsourcing.easycommons.uuid.SimpleUUIDGenerator;

public final class QualifiedUUIDGenerator
extends SimpleUUIDGenerator {
    private static final String SEPARATOR = ":";
    public static final int UUID_GENERATED_PART_SIZE = new UUID().toString().length();
    private int uuidMaxLength;
    private String domain;

    public QualifiedUUIDGenerator(String domain) {
        assert (domain != null) : "UUID domain cannot be null. See SimpleUUIDGenerator for non qualified UUID";
        this.domain = domain;
        this.uuidMaxLength = domain.length() + SEPARATOR.length() + UUID_GENERATED_PART_SIZE;
    }

    @Override
    public String getNewID() {
        StringBuilder builder = new StringBuilder(this.uuidMaxLength);
        builder.append(this.domain).append(SEPARATOR);
        return builder.append(super.getNewID()).toString();
    }

    public String getDomain() {
        return this.domain;
    }

    public int getUuidMaxLength() {
        return this.uuidMaxLength;
    }

    public static String getSeparator() {
        return SEPARATOR;
    }
}

