/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.network;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.logging.Logger;

public final class NetworkHelper {
    private static final Logger log = Logger.getLogger(NetworkHelper.class.getName());

    public static boolean isPortUsed(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
            return false;
        }
        catch (IOException e) {
            log.warning(String.valueOf(port) + " is open. Another process may own it.");
            return true;
        }
    }

    public static boolean oneOfPortsOpen(int ... ports) {
        int i = 0;
        while (i < ports.length) {
            if (NetworkHelper.isPortUsed(ports[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

