/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.easybox.resolver;

import com.ebmwebsourcing.easycommons.uri.URIHelper;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;

public class URIMemoryMultipleResolvers
extends URIMultipleResolvers {
    private static Map<String, Object> memoryCatalog = Collections.synchronizedMap(new HashMap());

    public URIMemoryMultipleResolvers() {
    }

    public URIMemoryMultipleResolvers(URIResolver ... resolvers) {
        super(resolvers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Source resolve(String href, String base) throws TransformerException {
        Object res = null;
        try {
            String key = null;
            key = href.lastIndexOf("/") > 0 ? href.substring(href.lastIndexOf("/") + 1) : href;
            res = memoryCatalog.get(key);
            if (res == null) {
                URI uri;
                res = super.resolve(href, base);
                if (res == null) return (Source)res;
                if (res instanceof DOMSource || res instanceof StreamSource) {
                    memoryCatalog.put(key, SourceHelper.fork((Source)((Source)res)));
                }
                if (!(res instanceof SAXSource)) throw new TransformerException("Source not supported: " + res);
                URI baseURI = null;
                if (base != null) {
                    baseURI = URI.create(base);
                }
                if ((uri = URIHelper.resolve((URI)baseURI, (String)href)) == null || !uri.isAbsolute()) throw new TransformerException("Error: found SaxSource from no absolute URI");
                memoryCatalog.put(key, uri);
                return (Source)res;
            } else if (res instanceof DOMSource || res instanceof StreamSource) {
                res = SourceHelper.fork((Source)((Source)res));
                return (Source)res;
            } else {
                if (!(res instanceof URI)) return (Source)res;
                res = new SAXSource(new InputSource(((URI)res).toURL().openStream()));
            }
            return (Source)res;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransformerException(e);
        }
    }
}

