/****************************************************************************
 * Copyright (c) 2010-2012, EBM WebSourcing - All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the University of California, Berkeley nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE REGENTS AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************************/

package com.ebmwebsourcing.easycommons.research.util.easybox.resolver;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.InputSource;

import com.ebmwebsourcing.easycommons.uri.URIHelper;
import com.ebmwebsourcing.easycommons.xml.SourceHelper;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;

public class URIMemoryMultipleResolvers extends URIMultipleResolvers {


	private static Map<String, Object> memoryCatalog = Collections.synchronizedMap(new HashMap<String, Object>());


	public URIMemoryMultipleResolvers() {
		super();
	}

	public URIMemoryMultipleResolvers(URIResolver... resolvers) {
		super(resolvers);
	}

	@Override
	public synchronized Source resolve(String href, String base) throws TransformerException {
		Object res = null;
		try {
			String key = null;
			if(href.lastIndexOf("/") > 0) {
				key = href.substring(href.lastIndexOf("/") + 1);
			} else {
				key = href;
			}
			//System.out.println("888888888888888888888888888 href : " + href);
			//System.out.println("888888888888888888888888888 key : " + key);
			res = memoryCatalog.get(key);
			if(res == null) {
				res = super.resolve(href, base);
				if(res != null) {
					if(res instanceof DOMSource || res instanceof StreamSource) {
						memoryCatalog.put(key, SourceHelper.fork((Source)res));
					} else if(res instanceof SAXSource) {
						URI baseURI = null;
						if(base != null) {
							baseURI = URI.create(base);
						}
						URI uri = URIHelper.resolve(baseURI, href);
						if(uri != null && uri.isAbsolute()) {
							memoryCatalog.put(key, uri);
						} 
					} else {
						throw new TransformerException("Source not supported: " + res);
					}
				}
			} else {
				//System.out.println("888888888888888888888888888 source found for key: " + key);
				if(res instanceof DOMSource || res instanceof StreamSource) {
					res = SourceHelper.fork((Source)res);
				} else if(res instanceof URI) {
					res = new SAXSource(new InputSource(((URI)res).toURL().openStream()));
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new TransformerException(e);
		}
		return (Source)res;
	}

	public void addResolver(URIResolver r) {
		this.resolvers.add(r);
	}

}
