/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.research.util.jaxws;

import javax.jws.WebService;

public class JAXWSHelper {
    public static final Class<?> getWebServiceClass(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        if (null != cls.getAnnotation(WebService.class)) {
            return cls;
        }
        for (Class<?> inf : cls.getInterfaces()) {
            if (null == inf.getAnnotation(WebService.class)) continue;
            return inf;
        }
        return JAXWSHelper.getWebServiceClass(cls.getSuperclass());
    }

    public static final String getWebServiceName(Class<?> wsClass) {
        String serviceName = null;
        WebService anno = wsClass.getAnnotation(WebService.class);
        if (anno != null) {
            serviceName = anno.serviceName() == null || anno.serviceName().trim().length() == 0 ? wsClass.getSimpleName() : anno.serviceName();
        }
        return serviceName;
    }

    public static final String getWebServiceWsdlLocation(Class<?> wsClass) {
        WebService anno = wsClass.getAnnotation(WebService.class);
        if (anno != null) {
            return anno.wsdlLocation();
        }
        return null;
    }

    public static final String getWebServiceTargetNameSpace(Class<?> wsClass) {
        WebService anno = wsClass.getAnnotation(WebService.class);
        if (anno != null) {
            return anno.targetNamespace();
        }
        return null;
    }

    public static boolean hasWebServiceAnnotation(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (null != cls.getAnnotation(WebService.class)) {
            return true;
        }
        for (Class<?> inf : cls.getInterfaces()) {
            if (null == inf.getAnnotation(WebService.class)) continue;
            return true;
        }
        return JAXWSHelper.hasWebServiceAnnotation(cls.getSuperclass());
    }
}

