package com.ebmwebsourcing.easycommons.research.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.easycommons.research.util.SOAException;

public class FileReader {

	private List<String> lines = new ArrayList<String>();
	
	public FileReader(File f) throws SOAException {
		try {
			java.io.FileReader fr = new java.io.FileReader(f);
			BufferedReader br = new BufferedReader(fr);
			String line;
			while ((line=br.readLine())!=null){
				lines.add(line);
			}

			br.close();
			fr.close();
		} catch (FileNotFoundException e) {
			throw new SOAException(e);
		} catch (IOException e) {
			throw new SOAException(e);
		}
	}

	public List<String> getLines() {
		return lines;
	}
}
