package com.ebmwebsourcing.easycommons.research.util.esb;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;


public class EndpointAddress {
	
	private String namespace = null;
	
	private String servicename = null;
	
	private String endpointname = null;
	
	private List<QueryParam> params = null;
	
	public EndpointAddress(QName sn, String en, QueryParam... params) {
		this(sn.getNamespaceURI(), sn.getLocalPart(), en, params);
	}
	
	@SuppressWarnings("unchecked")
	public EndpointAddress(String ns, String sn, String en, QueryParam... params) {
		this.namespace = ns;
		this.servicename = sn;
		this.endpointname = en;
		this.params = Arrays.asList(params);
	}
	
	public String getNamespace() {
		return namespace;
	}

	public String getServicename() {
		return servicename;
	}

	public String getEndpointname() {
		return endpointname;
	}
	
	public Map<String, String> getQueryMap() {
		Map<String, String> map = new HashMap<String, String>();
		for(QueryParam p: params) {
			map.put(p.getKey(), p.getValue());
		}
		return map;
	}
	
	public String getQueryString() {
		String res = "";
		if(params != null && !params.isEmpty()) {
			for(QueryParam p: params) {
				res = p + ", ";
			}
			res = res.substring(0, res.length() - ", ".length());
		}
		return res;
	}

	@Override
	public String toString() {
		return "EndpointAddress [namespace=" + namespace + ", servicename="
				+ servicename + ", endpointname=" + endpointname + "]";
	}
	
	
}
