/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easycommons.explorer;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.petalslink.easycommons.explorer.BindingG;
import com.petalslink.easycommons.explorer.ComponentG;
import com.petalslink.easycommons.explorer.ControllerG;
import com.petalslink.easycommons.explorer.CornerG;
import com.petalslink.easycommons.explorer.ExplorerFrame;
import com.petalslink.easycommons.explorer.MenuMouseExplorer;
import com.petalslink.easycommons.explorer.ReferenceG;
import com.petalslink.easycommons.explorer.ServiceG;
import com.petalslink.easycommons.explorer.TextG;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class ExplorerView
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static int SPACE = 20;
    private JScrollPane jScrollPaneView = new JScrollPane();
    private ComponentG component;
    private List<BindingG> bindings;
    private TextG internalItemNameToPrint = null;
    private Object draggedItem = null;
    private Object resizableItem = null;
    private MenuMouseExplorer mme = null;
    private JFrame parent;

    public ExplorerView(Dimension dim, Component model, JFrame parent) throws SCAException {
        this.jScrollPaneView.add(this);
        this.initComponents();
        this.parent = parent;
        this.mme = new MenuMouseExplorer(this);
        this.setBackground(Color.white);
        this.setSize(dim);
        this.component = new ComponentG(this, model, null, SPACE, SPACE, this.getWidth() - SPACE * 2, this.getHeight() - SPACE * 2, true);
        this.component.setTopComponent(true);
        this.bindings = this.createBindings();
    }

    public JScrollPane getjScrollPaneView() {
        return this.jScrollPaneView;
    }

    private List<BindingG> createBindings() {
        ArrayList<BindingG> bindings = new ArrayList<BindingG>();
        try {
            for (ComponentG child : this.component.getUnderComponents()) {
                Map binds = SCAHelper.getSCAHelper().getServerInterfacesLinkedToClientInterfacesOfComponent(child.getModel());
                for (Map.Entry entry : binds.entrySet()) {
                    if (entry.getValue() == null) continue;
                    ReferenceG ref = child.findReference((String)entry.getKey());
                    ServiceG serv = this.component.findService(SCAHelper.getSCAHelper().getName(((Interface)entry.getValue()).getFcItfOwner()), ((Interface)entry.getValue()).getFcItfOwner().getFcInterface(((Interface)entry.getValue()).getFcItfName()).getClass().getInterfaces()[0]);
                    bindings.add(new BindingG(ref, serv));
                }
            }
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        catch (SCAException e) {
            e.printStackTrace();
        }
        return bindings;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(Color.white);
        g2.drawRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.resizableItem != this.component) {
            this.component.getRectangle().x = SPACE;
            this.component.getRectangle().y = SPACE;
            this.component.getRectangle().width = this.getWidth() - SPACE * 2;
            this.component.getRectangle().height = this.getHeight() - SPACE * 2;
        }
        this.component.update(g);
        if (this.mme.getjMenuItemPrintBindings().isSelected()) {
            for (BindingG b : this.bindings) {
                b.update(g2);
            }
        }
        if (this.internalItemNameToPrint != null) {
            g.setColor(this.internalItemNameToPrint.getColor());
            g.drawString(this.internalItemNameToPrint.getText(), (int)this.internalItemNameToPrint.getX(), (int)this.internalItemNameToPrint.getY());
        }
        g.dispose();
    }

    public MenuMouseExplorer getMme() {
        return this.mme;
    }

    public ComponentG getComponent() {
        return this.component;
    }

    public static Object getObjectContainedIn(ComponentG parent, MouseEvent evt) {
        for (ServiceG service : parent.getServices()) {
            if (!service.contains(evt.getX(), evt.getY())) continue;
            return service;
        }
        for (ReferenceG reference : parent.getReferences()) {
            if (!reference.contains(evt.getX(), evt.getY())) continue;
            return reference;
        }
        for (ControllerG controller : parent.getControllers()) {
            if (!controller.contains(evt.getX(), evt.getY())) continue;
            return controller;
        }
        if (parent.getCorner().contains(evt.getX(), evt.getY())) {
            return parent.getCorner();
        }
        for (ComponentG child : parent.getUnderComponents()) {
            Object item = ExplorerView.getObjectContainedIn(child, evt);
            if (item == null) {
                if (!child.contains(evt.getX(), evt.getY())) continue;
                return child;
            }
            if (item instanceof ComponentG) {
                return child;
            }
            return item;
        }
        return null;
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExplorerView.this.formMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                ExplorerView.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ExplorerView.this.formMouseReleased(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ExplorerView.this.formMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                ExplorerView.this.formMouseMoved(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 769, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 603, Short.MAX_VALUE));
    }

    private void formMousePressed(MouseEvent evt) {
        ComponentG component;
        this.draggedItem = null;
        this.resizableItem = null;
        Object selectedItem = ExplorerView.getObjectContainedIn(this.component, evt);
        if (selectedItem instanceof CornerG) {
            CornerG corner = (CornerG)selectedItem;
            if (corner.contains(evt.getX(), evt.getY())) {
                this.resizableItem = corner.getParent();
                corner.getParent().setResizable(true);
            }
        } else if (selectedItem instanceof ComponentG && (component = (ComponentG)selectedItem).contains(evt.getX(), evt.getY())) {
            this.draggedItem = component;
            if (this.component.getUnderComponents().contains(component)) {
                this.component.getUnderComponents().remove(component);
                this.component.getUnderComponents().add(component);
            }
            component.setMove(true);
        }
    }

    private void formMouseClicked(MouseEvent evt) {
        try {
            this.repaint();
            Object selectedItem = ExplorerView.getObjectContainedIn(this.component, evt);
            if (evt.getButton() == 1 && evt.getClickCount() == 2 && selectedItem instanceof ComponentG) {
                this.setComponent((ComponentG)selectedItem);
            }
            this.mme.setVisible(false);
            if (evt.getButton() == 3) {
                if (this.parent instanceof ExplorerFrame) {
                    ExplorerFrame explorerFrame = (ExplorerFrame)this.parent;
                    this.mme.setLocation(evt.getX() + explorerFrame.getX() + explorerFrame.getjTree().getWidth() - this.mme.getWidth() / 2, evt.getY() + explorerFrame.getY() + 70);
                }
                this.mme.setVisible(true);
            }
        }
        catch (SCAException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explorer component Interrupted", 0);
        }
    }

    public void setComponent(ComponentG selectedItem) throws SCAException {
        this.component.setTopComponent(false);
        if (this.component.getParent() != null) {
            this.component.setDepth(false);
        }
        this.component = selectedItem;
        this.component.getRectangle().x = SPACE;
        this.component.getRectangle().y = SPACE;
        this.component.getRectangle().width = this.getWidth() - SPACE * 2;
        this.component.getRectangle().height = this.getHeight() - SPACE * 2;
        this.component.setTopComponent(true);
        this.component.init();
        this.component.setDepth(true);
        this.bindings = this.createBindings();
        this.repaint();
    }

    public static Dimension getTextSize(Graphics2D g2, String text) {
        FontMetrics metrics = g2.getFontMetrics();
        int hgt = metrics.getHeight();
        int adv = metrics.stringWidth(text);
        Dimension textSize = new Dimension(adv + 2, hgt + 2);
        return textSize;
    }

    private void formMouseDragged(MouseEvent evt) {
        if (this.draggedItem != null && this.draggedItem instanceof ComponentG) {
            ((ComponentG)this.draggedItem).setLocation(evt.getX(), evt.getY());
        } else if (this.resizableItem != null && this.resizableItem instanceof ComponentG) {
            ((ComponentG)this.resizableItem).resize(evt.getX(), evt.getY());
        }
        this.repaint();
    }

    private void formMouseMoved(MouseEvent evt) {
        Object selectedItem = ExplorerView.getObjectContainedIn(this.component, evt);
        if (selectedItem instanceof ServiceG) {
            ServiceG s = (ServiceG)selectedItem;
            this.internalItemNameToPrint = new TextG(s.getName(), Color.black, s.getRectangle().x, s.getRectangle().y + s.getRectangle().height);
        } else if (selectedItem instanceof ControllerG) {
            ControllerG c = (ControllerG)selectedItem;
            this.internalItemNameToPrint = new TextG(c.getName(), Color.black, c.getRectangle().x, c.getRectangle().y - c.getRectangle().height);
        } else if (selectedItem instanceof ReferenceG) {
            ReferenceG r = (ReferenceG)selectedItem;
            this.internalItemNameToPrint = new TextG(r.getName(), Color.black, r.getRectangle().x - ExplorerView.getTextSize((Graphics2D)((Graphics2D)this.getGraphics()), (String)r.getName()).width, r.getRectangle().y + r.getRectangle().height);
        } else {
            this.internalItemNameToPrint = null;
        }
        this.repaint();
    }

    private void formMouseReleased(MouseEvent evt) {
        if (this.draggedItem instanceof ComponentG) {
            ((ComponentG)this.draggedItem).setMove(false);
        }
        if (this.resizableItem instanceof ComponentG) {
            ((ComponentG)this.resizableItem).setResizable(false);
        }
        this.draggedItem = null;
        this.resizableItem = null;
    }
}

