/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easycommons.explorer;

import com.petalslink.easycommons.explorer.ExplorerView;
import com.petalslink.easycommons.explorer.Property;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class ServiceG {
    public static int DEFAULT_SIZE = ExplorerView.SPACE / 2;
    public Color color = null;
    protected Rectangle rect = null;
    private ExplorerView explorer = null;
    private Class<?> model;
    private List<Property> properties = new ArrayList<Property>();

    public ServiceG(ExplorerView explorer, Class<?> model) {
        this.color = Color.green;
        this.model = model;
        this.explorer = explorer;
        this.init();
        this.properties.add(new Property("name", this.model.getSimpleName()));
    }

    public void update(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.color);
        g2.draw(this.rect);
        g2.fill(this.rect);
    }

    protected void init() {
        this.rect = new Rectangle(0, 0, DEFAULT_SIZE, DEFAULT_SIZE);
    }

    public boolean contains(int x, int y) {
        return this.rect.contains(x, y);
    }

    public String getName() {
        return this.model.getSimpleName();
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    public void setLocation(int x, int y) {
        Point pos = this.checkLocation(x, y);
        this.rect.x = pos.x;
        this.rect.y = pos.y;
    }

    private Point checkLocation(int x, int y) {
        Point p = new Point(x, y);
        if (x < this.explorer.getX()) {
            p.x = this.explorer.getX();
        } else if (x > this.explorer.getX() + this.explorer.getWidth() - this.rect.width) {
            p.x = this.explorer.getX() + this.explorer.getWidth() - this.rect.width;
        }
        if (y < this.explorer.getY()) {
            p.y = this.explorer.getY();
        } else if (y > this.explorer.getY() + this.explorer.getHeight() - this.rect.height) {
            p.y = this.explorer.getY() + this.explorer.getHeight() - this.rect.height;
        }
        return p;
    }

    public double getCenterX() {
        return this.rect.x + this.rect.width / 2;
    }

    public double getCenterY() {
        return this.rect.y + this.rect.height / 2;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getName();
    }
}

