/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easycommons.explorer;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easycommons.sca.helper.impl.SCAHelper;
import com.petalslink.easycommons.explorer.ControllerG;
import com.petalslink.easycommons.explorer.CornerG;
import com.petalslink.easycommons.explorer.ExplorerView;
import com.petalslink.easycommons.explorer.Property;
import com.petalslink.easycommons.explorer.ReferenceG;
import com.petalslink.easycommons.explorer.ServiceG;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.util.Fractal;

public class ComponentG {
    public static int DEFAULT_HEIGHT_TEXT = 30;
    private int lastx = 0;
    private int lasty = 0;
    private boolean move = false;
    private boolean resizable = false;
    private Rectangle rect;
    private CornerG corner;
    private ExplorerView explorer;
    private List<ComponentG> underComponents = new ArrayList<ComponentG>();
    private List<ServiceG> services = new ArrayList<ServiceG>();
    private List<ReferenceG> references = new ArrayList<ReferenceG>();
    private List<ControllerG> controllers = new ArrayList<ControllerG>();
    private List<Property> properties = new ArrayList<Property>();
    private Component model;
    private ComponentG parent;
    private QName name;
    private boolean depth = false;
    private boolean topComponent = false;

    public ComponentG(ExplorerView explorer, Component component, ComponentG parent, int init_x, int init_y, int width, int height, boolean depth) throws SCAException {
        this.explorer = explorer;
        this.model = component;
        this.parent = parent;
        this.rect = new Rectangle(init_x, init_y, width, height);
        this.rect.setLocation(init_x, init_y);
        this.corner = new CornerG(this.explorer, this);
        this.depth = depth;
        this.name = QName.valueOf(SCAHelper.getSCAHelper().getName(this.model));
        this.init();
    }

    public void init() throws SCAException {
        try {
            List childs = SCAHelper.getSCAHelper().getComponents(this.model);
            List<Rectangle> rects = this.createGrille(childs.size(), this.rect.x, this.rect.y, this.rect.width, this.rect.height);
            this.services.clear();
            this.controllers.clear();
            Object[] objectArray = this.model.getFcInterfaces();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                Class<?>[] classArray = obj.getClass().getInterfaces();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> c = classArray[n4];
                    if (c.getPackage().getName().startsWith("org.ow2.frascati") || c.getPackage().getName().startsWith("org.objectweb.fractal") || c.getPackage().getName().startsWith("org.oasisopen.sca")) {
                        this.controllers.add(new ControllerG(this.explorer, c));
                    } else {
                        this.services.add(new ServiceG(this.explorer, c));
                    }
                    ++n4;
                }
                ++n2;
            }
            this.references.clear();
            BindingController componentBindingController = Fractal.getBindingController((Component)this.model);
            String[] stringArray = componentBindingController.listFc();
            int n5 = stringArray.length;
            n = 0;
            while (n < n5) {
                String clientItfName = stringArray[n];
                this.references.add(new ReferenceG(this.explorer, clientItfName));
                ++n;
            }
            int i = 0;
            this.underComponents.clear();
            for (Component child : childs) {
                this.underComponents.add(new ComponentG(this.explorer, child, this, rects.get((int)i).x, rects.get((int)i).y, rects.get((int)i).width, rects.get((int)i).height, false));
                ++i;
            }
            this.properties.clear();
            this.properties.add(new Property("name", this.getName().getLocalPart()));
            this.properties.add(new Property("namespace", this.getName().getNamespaceURI()));
            this.properties.add(new Property("number of child components", this.underComponents.size()));
            this.properties.add(new Property("number of services", this.services.size()));
            this.properties.add(new Property("number of references", this.references.size()));
            this.properties.add(new Property("number of controllers", this.controllers.size()));
        }
        catch (NoSuchInterfaceException e) {
            throw new SCAException((Throwable)e);
        }
    }

    public QName getName() {
        return this.name;
    }

    private List<Rectangle> createGrille(int number, int x, int y, int width, int height) {
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>();
        int number_col = 0;
        int number_row = 0;
        if (number % 2 == 0) {
            number_col = (int)Math.sqrt(number) + 1;
            number_row = (int)Math.sqrt(number);
        } else {
            number_col = (int)Math.sqrt(number) + 1;
            number_row = (int)Math.sqrt(number) + 1;
        }
        if (number_col == 0) {
            number_col = 1;
        }
        if (number_row == 0) {
            number_row = 1;
        }
        int width_col = (width - ExplorerView.SPACE * 2 * number_col) / number_col;
        int height_row = (height - DEFAULT_HEIGHT_TEXT - ExplorerView.SPACE * number_row * 2) / number_row;
        int col = 0;
        int row = 0;
        int rect_x = 0;
        int rect_y = 0;
        int i = 0;
        while (i < number) {
            if (col >= number_col) {
                col = 0;
                ++row;
            }
            rect_x = x + ExplorerView.SPACE + width_col * col + ExplorerView.SPACE * 2 * col;
            rect_y = y + ExplorerView.SPACE + height_row * row + ExplorerView.SPACE * 2 * row + DEFAULT_HEIGHT_TEXT;
            rects.add(new Rectangle(rect_x, rect_y, width_col, height_row));
            ++col;
            ++i;
        }
        return rects;
    }

    public void update(Graphics g) {
        try {
            Graphics2D g2 = (Graphics2D)g;
            if (this.move) {
                g2.setPaint(Color.white);
                g2.drawRect(this.lastx, this.lasty, (int)this.rect.getWidth(), (int)this.rect.getHeight());
                g2.fillRect(this.lastx, this.lasty, (int)this.rect.getWidth(), (int)this.rect.getHeight());
                this.lastx = this.rect.x;
                this.lasty = this.rect.y;
            }
            if (!this.topComponent) {
                if (this.underComponents.size() > 0 && !this.depth) {
                    g2.setStroke(new BasicStroke(8.0f));
                    g2.setColor(new Color(0, 191, 255));
                    g2.fill(this.rect);
                } else {
                    g2.setStroke(new BasicStroke(8.0f));
                    g2.setColor(new Color(176, 226, 255));
                    g2.fill(this.rect);
                }
            } else {
                g2.setStroke(new BasicStroke(8.0f));
                g2.setColor(Color.white);
                g2.fill(this.rect);
            }
            if (SCAHelper.getSCAHelper().isStarted(this.model)) {
                g2.setColor(new Color(132, 112, 255));
            } else {
                g2.setColor(Color.red);
            }
            g2.draw(this.rect);
            g2.setColor(Color.black);
            Dimension textSize = ExplorerView.getTextSize(g2, this.name.getLocalPart());
            g2.drawString(this.name.getLocalPart(), this.rect.x + this.rect.width / 2 - textSize.width / 2, this.rect.y + ExplorerView.SPACE);
            int init_x = this.rect.x - ServiceG.DEFAULT_SIZE / 2;
            int spacey = this.rect.height / (this.services.size() + 1);
            int init_y = this.rect.y + spacey;
            for (ServiceG s : this.services) {
                s.setLocation(init_x, init_y);
                s.update(g2);
                init_y += spacey;
            }
            int spacex = this.rect.width / (this.controllers.size() + 1);
            init_x = this.rect.x + spacex;
            init_y = this.rect.y - ControllerG.DEFAULT_SIZE / 2;
            for (ControllerG c : this.controllers) {
                c.setLocation(init_x, init_y);
                c.update(g2);
                init_x += spacex;
            }
            init_x = this.rect.x + this.rect.width - ReferenceG.DEFAULT_SIZE / 2;
            spacey = this.rect.height / (this.references.size() + 1);
            init_y = this.rect.y + spacey;
            for (ReferenceG r : this.references) {
                r.setLocation(init_x, init_y);
                r.update(g2);
                init_y += spacey;
            }
            this.corner.setLocation(this.rect.x + this.rect.width - CornerG.DEFAULT_SIZE / 2, this.rect.y + this.rect.height - CornerG.DEFAULT_SIZE / 2);
            this.corner.update(g2);
            if (this.depth) {
                for (ComponentG child : this.underComponents) {
                    child.update(g2);
                }
            }
            if (this.explorer.getMme().getjMenuItemPrintServices().isSelected()) {
                g.setColor(Color.black);
                for (ServiceG s : this.services) {
                    g.drawString(s.getName(), s.getRectangle().x, s.getRectangle().y + s.getRectangle().height);
                }
            }
            if (this.explorer.getMme().getjMenuItemPrintReferences().isSelected()) {
                g.setColor(Color.black);
                for (ReferenceG r : this.references) {
                    g.drawString(r.getName(), r.getRectangle().x - ExplorerView.getTextSize((Graphics2D)g2, (String)r.getName()).width, r.getRectangle().y + r.getRectangle().height);
                }
            }
        }
        catch (SCAException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Explorer component Interrupted", 0);
        }
    }

    public boolean contains(int x, int y) {
        return this.rect.contains(x, y);
    }

    public void setLocation(int x, int y) {
        Point pos = this.checkLocation(x, y);
        this.rect.x = pos.x;
        this.rect.y = pos.y;
    }

    public Rectangle getRectangle() {
        return this.rect;
    }

    private Point checkLocation(int x, int y) {
        Point p = new Point(x, y);
        int parent_x = 0;
        int parent_y = 0;
        int parent_width = 0;
        int parent_height = 0;
        if (this.parent != null) {
            parent_x = this.parent.getRectangle().x;
            parent_y = this.parent.getRectangle().y;
            parent_width = this.parent.getRectangle().width;
            parent_height = this.parent.getRectangle().height;
        } else {
            parent_x = this.explorer.getX();
            parent_y = this.explorer.getY();
            parent_width = this.explorer.getWidth();
            parent_height = this.explorer.getHeight();
        }
        if (x < parent_x) {
            p.x = parent_x;
        } else if (x > parent_x + parent_width - this.rect.width) {
            p.x = parent_x + parent_width - this.rect.width;
        }
        if (y < parent_y) {
            p.y = parent_y;
        } else if (y > parent_y + parent_height - this.rect.height) {
            p.y = parent_y + parent_height - this.rect.height;
        }
        return p;
    }

    public double getCenterX() {
        return this.rect.x + this.rect.width / 2;
    }

    public double getCenterY() {
        return this.rect.y + this.rect.height / 2;
    }

    public boolean isMove() {
        return this.move;
    }

    public void setMove(boolean move) {
        this.move = move;
    }

    public List<ServiceG> getServices() {
        return this.services;
    }

    public List<ReferenceG> getReferences() {
        return this.references;
    }

    public List<ControllerG> getControllers() {
        return this.controllers;
    }

    public List<ComponentG> getUnderComponents() {
        return this.underComponents;
    }

    public Component getModel() {
        return this.model;
    }

    public CornerG getCorner() {
        return this.corner;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void resize(int click_x, int click_y) {
        if (click_x > this.rect.x) {
            this.rect.width = click_x - this.rect.x;
        }
        if (click_y > this.rect.y) {
            this.rect.height = click_y - this.rect.y;
        }
        if (!this.topComponent) {
            this.setLocation(this.rect.x, this.rect.y);
        }
    }

    public void setSize(int width, int height) {
        this.rect.width = width;
        this.rect.height = height;
        this.setLocation(this.rect.x, this.rect.y);
    }

    public void setResizable(boolean resize) {
        this.resizable = resize;
    }

    public ReferenceG findReference(String key) {
        for (ReferenceG ref : this.references) {
            if (!ref.getName().equals(key)) continue;
            return ref;
        }
        return null;
    }

    public ServiceG findService(String componentName, Class<?> itf) {
        for (ComponentG child : this.underComponents) {
            if (!child.getName().toString().equals(componentName)) continue;
            for (ServiceG serv : child.getServices()) {
                if (!serv.getName().equals(itf.getSimpleName())) continue;
                return serv;
            }
        }
        return null;
    }

    public void setDepth(boolean depth) {
        this.depth = depth;
    }

    public ComponentG getParent() {
        return this.parent;
    }

    public void setTopComponent(boolean topComponent) {
        this.topComponent = topComponent;
    }

    public String toString() {
        return this.getName().getLocalPart();
    }
}

