/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easycommons.explorer;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.petalslink.easycommons.explorer.ComponentG;
import com.petalslink.easycommons.explorer.ControllerG;
import com.petalslink.easycommons.explorer.ExplorerView;
import com.petalslink.easycommons.explorer.PropertiesTableModel;
import com.petalslink.easycommons.explorer.ReferenceG;
import com.petalslink.easycommons.explorer.ServiceG;
import com.petalslink.easycommons.explorer.TreeComponentCellRenderer;
import com.petalslink.easycommons.explorer.TreeComponentModel;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import org.objectweb.fractal.api.Component;

public class ExplorerFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ExplorerView explorer;
    private Component model;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar;
    private JPanel jPanelContainerOfView;
    private JPanel jPanelMain;
    private JPanel jPanelViewAndProperties;
    private JScrollPane jScrollPaneTableProperty;
    private JScrollPane jScrollPaneTree;
    private JScrollPane jScrollPaneView;
    private JSplitPane jSplitPaneH;
    private JSplitPane jSplitPaneV;
    private JTable jTableProperties;
    private JTree jTree;

    public ExplorerFrame(Component comp) throws SCAException {
        this.initComponents();
        this.explorer = new ExplorerView(this.jPanelContainerOfView.getSize(), comp, this);
        this.jPanelContainerOfView.setLayout(new GridLayout(1, 1));
        this.jPanelContainerOfView.add(this.explorer);
        this.jTree.setModel(new TreeComponentModel(this.explorer.getComponent()));
        this.jTree.setCellRenderer(new TreeComponentCellRenderer());
        this.setTitle("Explore component: " + this.explorer.getComponent().getName());
        this.model = comp;
        this.jTableProperties.setModel(new PropertiesTableModel(this.explorer.getComponent().getProperties()));
        this.setLocation();
    }

    public JTree getjTree() {
        return this.jTree;
    }

    private void setLocation() {
        double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        this.setLocation((int)witdhScreen / 2 - this.getWidth() / 2, (int)heightScreen / 2 - this.getHeight() / 2);
    }

    private void initComponents() {
        this.jPanelMain = new JPanel();
        this.jSplitPaneV = new JSplitPane();
        this.jScrollPaneTree = new JScrollPane();
        this.jTree = new JTree();
        this.jPanelViewAndProperties = new JPanel();
        this.jSplitPaneH = new JSplitPane();
        this.jScrollPaneTableProperty = new JScrollPane();
        this.jTableProperties = new JTable();
        this.jScrollPaneView = new JScrollPane();
        this.jPanelContainerOfView = new JPanel();
        this.jMenuBar = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenu2 = new JMenu();
        this.setAlwaysOnTop(true);
        this.jSplitPaneV.setDividerLocation(300);
        this.jSplitPaneV.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ExplorerFrame.this.jSplitPaneVMouseDragged(evt);
            }
        });
        this.jTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ExplorerFrame.this.jTreeMouseClicked(evt);
            }
        });
        this.jScrollPaneTree.setViewportView(this.jTree);
        this.jSplitPaneV.setLeftComponent(this.jScrollPaneTree);
        this.jSplitPaneH.setDividerLocation(500);
        this.jSplitPaneH.setOrientation(0);
        this.jSplitPaneH.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ExplorerFrame.this.jSplitPaneHMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ExplorerFrame.this.jSplitPaneHMouseReleased(evt);
            }
        });
        this.jSplitPaneH.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                ExplorerFrame.this.jSplitPaneHMouseDragged(evt);
            }
        });
        this.jTableProperties.setModel(new DefaultTableModel(new Object[][]{new Object[4], new Object[4], new Object[4], new Object[4]}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPaneTableProperty.setViewportView(this.jTableProperties);
        this.jSplitPaneH.setBottomComponent(this.jScrollPaneTableProperty);
        GroupLayout jPanelContainerOfViewLayout = new GroupLayout(this.jPanelContainerOfView);
        this.jPanelContainerOfView.setLayout(jPanelContainerOfViewLayout);
        jPanelContainerOfViewLayout.setHorizontalGroup(jPanelContainerOfViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 598, Short.MAX_VALUE));
        jPanelContainerOfViewLayout.setVerticalGroup(jPanelContainerOfViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 497, Short.MAX_VALUE));
        this.jScrollPaneView.setViewportView(this.jPanelContainerOfView);
        this.jSplitPaneH.setLeftComponent(this.jScrollPaneView);
        GroupLayout jPanelViewAndPropertiesLayout = new GroupLayout(this.jPanelViewAndProperties);
        this.jPanelViewAndProperties.setLayout(jPanelViewAndPropertiesLayout);
        jPanelViewAndPropertiesLayout.setHorizontalGroup(jPanelViewAndPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneH, -1, 602, Short.MAX_VALUE));
        jPanelViewAndPropertiesLayout.setVerticalGroup(jPanelViewAndPropertiesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPaneH, -1, 613, Short.MAX_VALUE));
        this.jSplitPaneV.setRightComponent(this.jPanelViewAndProperties);
        GroupLayout jPanelMainLayout = new GroupLayout(this.jPanelMain);
        this.jPanelMain.setLayout(jPanelMainLayout);
        jPanelMainLayout.setHorizontalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 928, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPaneV, -1, 908, Short.MAX_VALUE).addContainerGap())));
        jPanelMainLayout.setVerticalGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 637, Short.MAX_VALUE).addGroup(jPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMainLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPaneV, -1, 615, Short.MAX_VALUE).addContainerGap())));
        this.jMenu1.setText("File");
        this.jMenuBar.add(this.jMenu1);
        this.jMenu2.setText("Edit");
        this.jMenuBar.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanelMain, -1, -1, Short.MAX_VALUE).addGap(0, 0, 0)));
        this.pack();
    }

    private void jTreeMouseClicked(MouseEvent evt) {
        try {
            if (this.jTree.getSelectionPath() != null) {
                Object selectedItem = this.jTree.getSelectionPath().getLastPathComponent();
                if (selectedItem instanceof ComponentG) {
                    this.explorer.setComponent((ComponentG)selectedItem);
                    this.jTableProperties.setModel(new PropertiesTableModel(((ComponentG)selectedItem).getProperties()));
                } else if (selectedItem instanceof ServiceG) {
                    this.jTableProperties.setModel(new PropertiesTableModel(((ServiceG)selectedItem).getProperties()));
                } else if (selectedItem instanceof ReferenceG) {
                    this.jTableProperties.setModel(new PropertiesTableModel(((ReferenceG)selectedItem).getProperties()));
                } else if (selectedItem instanceof ControllerG) {
                    this.jTableProperties.setModel(new PropertiesTableModel(((ControllerG)selectedItem).getProperties()));
                }
            }
        }
        catch (SCAException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explorer component Interrupted", 0);
        }
    }

    private void jSplitPaneVMouseDragged(MouseEvent evt) {
        this.explorer.repaint();
    }

    private void jSplitPaneHMouseDragged(MouseEvent evt) {
        this.explorer.repaint();
    }

    private void jSplitPaneHMousePressed(MouseEvent evt) {
        this.explorer.repaint();
    }

    private void jSplitPaneHMouseReleased(MouseEvent evt) {
        this.explorer.repaint();
    }
}

