package com.petalslink.easycommons.explorer;

import java.util.List;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class PropertiesTableModel extends AbstractTableModel implements TableModel {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private List<Property> properties = null;
	
	public PropertiesTableModel(List<Property> properties) {
		this.properties = properties;
	}
	
	@Override
	public String getColumnName(int col) {
		if(col == 0) {
			return "property name";
		} else if(col == 1) {
			return "value";
		} 
		return null;
	}
	
	@Override
	public int getColumnCount() {
		return 2;
	}

	@Override
	public int getRowCount() {
		return this.properties.size();
	}

	@Override
	public Object getValueAt(int row, int col) {
		String res = null;
		Property p = this.properties.get(row);
		if(col == 0) {
			res = p.getName();
		} else {
			res = p.getValue().toString();
		}
		return res;
	}

}
