package com.petalslink.easycommons.explorer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;

/**
 * The Ball class creates 5 balls.  Each ball increasingly blends
 * the color white with the specified color.
 */
public class BindingG {

	private Line2D line = null;

	protected int size;
	protected Color color;
 
	private ReferenceG client;
	private ServiceG provider;
	
	
	public BindingG(ReferenceG client, ServiceG provider) {
		this.color = Color.black;
		this.client = client;
		this.provider = provider;
		this.line = new Line2D.Double(client.getCenterX(), client.getCenterY(), provider.getCenterX(), provider.getCenterY());
	}


	public void update(Graphics g) {
		Graphics2D g2 = (Graphics2D) g;

		this.line.setLine(client.getCenterX(), client.getCenterY(), provider.getCenterX(), provider.getCenterY());
		
		g2.setStroke(new BasicStroke(5.0f, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND)); // Select the line style to use
		g2.setColor(this.color);
		g2.draw(this.line);
		g2.fill(this.line);
	}

	public boolean contains(int x, int y) {
		return this.line.contains(x, y);
	}

	public void setLocation(int x1, int y1, int x2, int y2) {
		this.line.setLine(x1, y1, x2, y2);
	}
}  

