/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ExplorerFrame.java
 *
 * Created on 24 mars 2011, 15:03:49
 */

package com.petalslink.easycommons.explorer;

import java.awt.GridLayout;
import java.awt.Toolkit;

import javax.swing.JOptionPane;

import org.objectweb.fractal.api.Component;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;

/**
 *
 * @author nsalatge
 */
public class ExplorerFrame extends javax.swing.JFrame {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private ExplorerView explorer;

	private Component model;

	/** Creates new form ExplorerFrame 
	 * @throws SCAException */
	public ExplorerFrame(Component comp) throws SCAException {
		initComponents();
		explorer = new ExplorerView(this.jPanelContainerOfView.getSize(), comp, this);
		this.jPanelContainerOfView.setLayout(new GridLayout(1,1));
		this.jPanelContainerOfView.add(explorer);


		this.jTree.setModel(new TreeComponentModel(explorer.getComponent()));
		this.jTree.setCellRenderer(new TreeComponentCellRenderer());

		this.setTitle("Explore component: " + explorer.getComponent().getName());

		this.model = comp;
		this.jTableProperties.setModel(new PropertiesTableModel(explorer.getComponent().getProperties()));

		this.setLocation();
	}

	public javax.swing.JTree getjTree() {
		return jTree;
	}

	private void setLocation() {
		double heightScreen = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
		double witdhScreen = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
		this.setLocation((int)witdhScreen/2 - this.getWidth()/2, (int)heightScreen/2 - this.getHeight()/2);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		jPanelMain = new javax.swing.JPanel();
		jSplitPaneV = new javax.swing.JSplitPane();
		jScrollPaneTree = new javax.swing.JScrollPane();
		jTree = new javax.swing.JTree();
		jPanelViewAndProperties = new javax.swing.JPanel();
		jSplitPaneH = new javax.swing.JSplitPane();
		jScrollPaneTableProperty = new javax.swing.JScrollPane();
		jTableProperties = new javax.swing.JTable();
		jScrollPaneView = new javax.swing.JScrollPane();
		jPanelContainerOfView = new javax.swing.JPanel();
		jMenuBar = new javax.swing.JMenuBar();
		jMenu1 = new javax.swing.JMenu();
		jMenu2 = new javax.swing.JMenu();

		setAlwaysOnTop(true);

		jSplitPaneV.setDividerLocation(300);
		jSplitPaneV.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
			public void mouseDragged(java.awt.event.MouseEvent evt) {
				jSplitPaneVMouseDragged(evt);
			}
		});

		jTree.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mouseClicked(java.awt.event.MouseEvent evt) {
				jTreeMouseClicked(evt);
			}
		});
		jScrollPaneTree.setViewportView(jTree);

		jSplitPaneV.setLeftComponent(jScrollPaneTree);

		jSplitPaneH.setDividerLocation(500);
		jSplitPaneH.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
		jSplitPaneH.addMouseListener(new java.awt.event.MouseAdapter() {
			public void mousePressed(java.awt.event.MouseEvent evt) {
				jSplitPaneHMousePressed(evt);
			}
			public void mouseReleased(java.awt.event.MouseEvent evt) {
				jSplitPaneHMouseReleased(evt);
			}
		});
		jSplitPaneH.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
			public void mouseDragged(java.awt.event.MouseEvent evt) {
				jSplitPaneHMouseDragged(evt);
			}
		});

		jTableProperties.setModel(new javax.swing.table.DefaultTableModel(
				new Object [][] {
						{null, null, null, null},
						{null, null, null, null},
						{null, null, null, null},
						{null, null, null, null}
				},
				new String [] {
						"Title 1", "Title 2", "Title 3", "Title 4"
				}
		));
		jScrollPaneTableProperty.setViewportView(jTableProperties);

		jSplitPaneH.setBottomComponent(jScrollPaneTableProperty);

		javax.swing.GroupLayout jPanelContainerOfViewLayout = new javax.swing.GroupLayout(jPanelContainerOfView);
		jPanelContainerOfView.setLayout(jPanelContainerOfViewLayout);
		jPanelContainerOfViewLayout.setHorizontalGroup(
				jPanelContainerOfViewLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 598, Short.MAX_VALUE)
		);
		jPanelContainerOfViewLayout.setVerticalGroup(
				jPanelContainerOfViewLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 497, Short.MAX_VALUE)
		);

		jScrollPaneView.setViewportView(jPanelContainerOfView);

		jSplitPaneH.setLeftComponent(jScrollPaneView);

		javax.swing.GroupLayout jPanelViewAndPropertiesLayout = new javax.swing.GroupLayout(jPanelViewAndProperties);
		jPanelViewAndProperties.setLayout(jPanelViewAndPropertiesLayout);
		jPanelViewAndPropertiesLayout.setHorizontalGroup(
				jPanelViewAndPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jSplitPaneH, javax.swing.GroupLayout.DEFAULT_SIZE, 602, Short.MAX_VALUE)
		);
		jPanelViewAndPropertiesLayout.setVerticalGroup(
				jPanelViewAndPropertiesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addComponent(jSplitPaneH, javax.swing.GroupLayout.DEFAULT_SIZE, 613, Short.MAX_VALUE)
		);

		jSplitPaneV.setRightComponent(jPanelViewAndProperties);

		javax.swing.GroupLayout jPanelMainLayout = new javax.swing.GroupLayout(jPanelMain);
		jPanelMain.setLayout(jPanelMainLayout);
		jPanelMainLayout.setHorizontalGroup(
				jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 928, Short.MAX_VALUE)
				.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(jPanelMainLayout.createSequentialGroup()
								.addContainerGap()
								.addComponent(jSplitPaneV, javax.swing.GroupLayout.DEFAULT_SIZE, 908, Short.MAX_VALUE)
								.addContainerGap()))
		);
		jPanelMainLayout.setVerticalGroup(
				jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGap(0, 637, Short.MAX_VALUE)
				.addGroup(jPanelMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
						.addGroup(jPanelMainLayout.createSequentialGroup()
								.addContainerGap()
								.addComponent(jSplitPaneV, javax.swing.GroupLayout.DEFAULT_SIZE, 615, Short.MAX_VALUE)
								.addContainerGap()))
		);

		jMenu1.setText("File");
		jMenuBar.add(jMenu1);

		jMenu2.setText("Edit");
		jMenuBar.add(jMenu2);

		setJMenuBar(jMenuBar);

		javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
		getContentPane().setLayout(layout);
		layout.setHorizontalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGap(0, 0, 0)
						.addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addGap(0, 0, 0))
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGap(0, 0, 0)
						.addComponent(jPanelMain, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
						.addGap(0, 0, 0))
		);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void jTreeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTreeMouseClicked
		try {
			if(this.jTree.getSelectionPath() != null) {
				Object selectedItem = this.jTree.getSelectionPath().getLastPathComponent();
				if(selectedItem instanceof ComponentG) {
					explorer.setComponent((ComponentG)selectedItem);
					this.jTableProperties.setModel(new PropertiesTableModel(((ComponentG)selectedItem).getProperties()));
				} else if(selectedItem instanceof ServiceG) {
					this.jTableProperties.setModel(new PropertiesTableModel(((ServiceG)selectedItem).getProperties()));
				} else if(selectedItem instanceof ReferenceG) {
					this.jTableProperties.setModel(new PropertiesTableModel(((ReferenceG)selectedItem).getProperties()));
				} else if(selectedItem instanceof ControllerG) {
					this.jTableProperties.setModel(new PropertiesTableModel(((ControllerG)selectedItem).getProperties()));
				}
			}
		} catch (SCAException e) {
			e.printStackTrace();
			JOptionPane.showMessageDialog(this,
					e.getMessage(), 
					"Explorer component Interrupted", JOptionPane.ERROR_MESSAGE);
		}
	}//GEN-LAST:event_jTreeMouseClicked

	private void jSplitPaneVMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSplitPaneVMouseDragged
		this.explorer.repaint();
	}//GEN-LAST:event_jSplitPaneVMouseDragged

	private void jSplitPaneHMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSplitPaneHMouseDragged
		this.explorer.repaint();
	}//GEN-LAST:event_jSplitPaneHMouseDragged

	private void jSplitPaneHMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSplitPaneHMousePressed
		this.explorer.repaint();
	}//GEN-LAST:event_jSplitPaneHMousePressed

	private void jSplitPaneHMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSplitPaneHMouseReleased
		this.explorer.repaint();
	}//GEN-LAST:event_jSplitPaneHMouseReleased


	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JMenu jMenu1;
	private javax.swing.JMenu jMenu2;
	private javax.swing.JMenuBar jMenuBar;
	private javax.swing.JPanel jPanelContainerOfView;
	private javax.swing.JPanel jPanelMain;
	private javax.swing.JPanel jPanelViewAndProperties;
	private javax.swing.JScrollPane jScrollPaneTableProperty;
	private javax.swing.JScrollPane jScrollPaneTree;
	private javax.swing.JScrollPane jScrollPaneView;
	private javax.swing.JSplitPane jSplitPaneH;
	private javax.swing.JSplitPane jSplitPaneV;
	private javax.swing.JTable jTableProperties;
	private javax.swing.JTree jTree;
	// End of variables declaration//GEN-END:variables

}
