package com.ebmwebsourcing.easycommons.soap.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Message;
import org.petalslink.abslayer.service.api.Part;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectFactory;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.SchemaHelper;
import com.ebmwebsourcing.easyschema10.api.SchemaOfSchemas;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;



public class SOAPMessageGenerator {

	public enum Direction {
		REQUEST("request"), RESPONSE(
		"response");

		private final String value;


		private Direction(final String value) {
			this.value = value;
		}

		public String value() {
			return this.value;
		}

		public boolean equals(final String val) {
			return this.toString().equals(val);
		}

		/*
		 * (non-Javadoc)
		 * 
		 * @see java.lang.Enum#toString()
		 */
		@Override
		public String toString() {
			return this.value;
		}
	}

	private Description desc;

	private SOAPAdapter adapter;
	
	private Map<Type, Object> defaultType = XSD2XML.createDefaultMap("?");

	public SOAPMessageGenerator(Description desc) {
		this.desc = desc;
		this.adapter = new SOAPAdapter(desc);
		
		defaultType.put(SchemaHelper.findTypeByQName(SchemaOfSchemas.getSchema(), new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "int")), "-1");
		defaultType.put(SchemaHelper.findTypeByQName(SchemaOfSchemas.getSchema(), new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "long")), "-1");
		defaultType.put(SchemaHelper.findTypeByQName(SchemaOfSchemas.getSchema(), new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "boolean")), "true");
		defaultType.put(SchemaHelper.findTypeByQName(SchemaOfSchemas.getSchema(), new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "date")), "2002-09-24");
		defaultType.put(SchemaHelper.findTypeByQName(SchemaOfSchemas.getSchema(), new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "time")), "09:00:00");
		defaultType.put(SchemaHelper.findTypeByQName(SchemaOfSchemas.getSchema(), new QName(SchemaOfSchemas.getSchema().getTargetNamespace(), "dateTime")), "2002-05-30T09:00:00");
		

	}


	public org.w3c.dom.Document generateSoapRequest(BindingOperation bop) throws SOAPException {
		org.w3c.dom.Document res = null;
		Binding wsdl11Binding = (Binding) bop.getBinding().getModel();
		if(bop.getBindingOperationInput() != null && SoapBindingHelper.getSoapBinding(wsdl11Binding).getTransport().equals("http://schemas.xmlsoap.org/soap/http")) {
			res = generateSoapMessage(bop, Direction.REQUEST);
		}
		return res;
	}

	public org.w3c.dom.Document generateSoapResponse(BindingOperation bop) throws SOAPException {
		org.w3c.dom.Document res = null;
		Binding wsdl11Binding = (Binding) bop.getBinding().getModel();
		if(bop.getBindingOperationOutput() != null && SoapBindingHelper.getSoapBinding(wsdl11Binding).getTransport().equals("http://schemas.xmlsoap.org/soap/http")) {
			res = generateSoapMessage(bop, Direction.RESPONSE);
		}
		return res;
	}

	public org.w3c.dom.Document generateSoapMessage(BindingOperation bop, Direction direction) throws SOAPException {
		org.w3c.dom.Document res = null;
		Document jdom = this.createGenericMessage(bop, direction);
		if(jdom != null) {
			jdom = this.adapter.format(jdom, bop, direction);
			try {
				DOMOutputter converter = new DOMOutputter();
				res = converter.output(jdom);
				res = SOAPSender.createSOAPMessageRequest(res);
			} catch (JDOMException e) {
				throw new SOAPException(e);
			}
		}
		return res;
	}



	private Document createGenericMessage(final BindingOperation bop, Direction direction)
	throws SOAPException {
		Document message = null;

		// Message not exist => Create message


		QName messageName = null;
		if(Direction.REQUEST.equals(direction)) {
			messageName = bop.findOperation().getInput().getMessageName();
		} else {
			messageName = bop.findOperation().getOutput().getMessageName();
		}


		final Message msg = desc.findMessage(messageName);

		if(msg == null) {
			throw new SOAPException("the message cannot be null: " + messageName);
		}

		// create all part
		final List<Element> elmts = new ArrayList<Element>();
		for(final Part part: msg.getParts()) {

			// create part
			if(part.getElement() != null) {
				final com.ebmwebsourcing.easyschema10.api.element.Element elmt = part.getElement();
				final Element content = XSD2XML.newInstance().generateElement(elmt, SchemaHelper.findParentSchema(elmt), defaultType, SchemaHelper.findParentSchema(elmt).getElementFormDefault(), 1, true, true);
				elmts.add(content);
			} else if(part.getType() != null) {
				XmlContextFactory xmlContextFactory = new XmlContextFactory();
				XmlContext xmlContext = xmlContextFactory.newContext();
				XmlObjectFactory xmlObjectFactory = xmlContext.getXmlObjectFactory();
				
				
				Schema[] schemas = desc.getTypes().findXmlAnyObjects(Schema.class);
				Schema selectedSchema = null;
				for(Schema s: schemas) {
					ComplexType ct = s.getComplexTypeByName(part.getType().getLocalPart());
					if(ct != null) {
						selectedSchema = s;
						break;
					}
					SimpleType st = s.getSimpleTypeByName(part.getType().getLocalPart());
					if(st != null) {
						selectedSchema = s;
						break;
					}
				}
				
				final com.ebmwebsourcing.easyschema10.api.element.Element elmt = xmlObjectFactory.create(com.ebmwebsourcing.easyschema10.api.element.Element.class);
				elmt.setName(part.getQName().getLocalPart());
				elmt.setType(part.getType());
				selectedSchema.addElement(elmt);
				final Element content = XSD2XML.newInstance().generateElement(elmt, SchemaHelper.findParentSchema(elmt), defaultType, SchemaHelper.findParentSchema(elmt).getElementFormDefault(), 1, true, true);
				content.setNamespace(null);
				elmts.add(content);
				selectedSchema.removeElement(elmt);
			}
		}

		final Element rootMessage = new Element(messageName.getLocalPart());
		final Document doc = new Document(rootMessage);
		if(messageName.getNamespaceURI() != null) {
			rootMessage.setNamespace(Namespace.getNamespace(messageName.getPrefix(), messageName.getNamespaceURI()));
		}

		// add all parts
		for(final Element elmt: elmts) {

			// test to avoid that a same prefix used by rootMessage and elmt have several namespaces
			if(((rootMessage.getNamespacePrefix() != null)&&(elmt.getNamespace(rootMessage.getNamespacePrefix()) != null))&&
					(!elmt.getNamespace(rootMessage.getNamespacePrefix()).getURI().equals(rootMessage.getNamespaceURI()))) {
				// change root prefix
				int i = 0;
				Namespace nsAlreadyUsed = elmt.getNamespace("cns" + i);
				while(nsAlreadyUsed != null) {
					i++;
					nsAlreadyUsed = elmt.getNamespace("cns" + i);
				}
				rootMessage.setNamespace(Namespace.getNamespace("cns" + i, rootMessage.getNamespaceURI()));
			}

			rootMessage.addContent(elmt.detach());
		}

		message = new Document((Element) doc.getRootElement().detach());


		return message;

	}
}
