/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.admin10.impl;



import javax.xml.namespace.QName;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.impl.AbstractJaxbXmlObjectImpl;
import com.ebmwebsourcing.easyesb.admin10.api.element.Description;
import com.ebmwebsourcing.easyesb.admin10.api.type.EndpointInformationType;

import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbEndpointInformationType;


class EndpointInformationTypeImpl extends AbstractJaxbXmlObjectImpl<EJaxbEndpointInformationType> implements
EndpointInformationType {

	protected EndpointInformationTypeImpl(XmlContext xmlContext, EJaxbEndpointInformationType jaxbModel) {
		super(xmlContext, jaxbModel);
	}


	@Override
	protected Class<? extends EJaxbEndpointInformationType> getCompliantModelClass() {
		return EJaxbEndpointInformationType.class;
	}


	@Override
	public void addInterface(QName itf) {
		this.getModelObject().getInterface().add(itf);
	}


	@Override
	public void clearInterfaces() {
		this.getModelObject().getInterface().clear();
	}


	@Override
	public Description getDescription() {
		if(getModelObject().getDescription() != null) {
			return this.getXmlContext().getXmlObjectFactory().wrap(getModelObject().getDescription(), Description.class);
		}
		return null;	
	}


	@Override
	public QName getInterfaceByName(QName itf) {
		QName res = null;
		for(QName i: this.getModelObject().getInterface()) {
			if(i.equals(itf)) {
				res = i;
				break;
			}
		}
		return res;
	}


	@Override
	public QName[] getInterfaces() {
		return (QName[]) this.getModelObject().getInterface().toArray();
	}


	@Override
	public QName getName() {
		return this.getModelObject().getName();
	}


	@Override
	public QName getNode() {
		return this.getModelObject().getNode();
	}


	@Override
	public QName getService() {
		return this.getModelObject().getService();
	}


	@Override
	public boolean hasDescription() {
		return this.getDescription() != null;
	}


	@Override
	public boolean hasName() {
		return this.getName() != null;
	}


	@Override
	public boolean hasNode() {
		return this.getNode() !=  null;
	}


	@Override
	public boolean hasService() {
		return this.getService() != null;
	}


	@Override
	public void removeInterface(QName itf) {
		this.getModelObject().getInterface().remove(itf);
	}


	@Override
	public void setDescription(Description desc) {
		setChild(desc, Description.class);
	}


	@Override
	public void setName(QName value) {
		this.getModelObject().setName(value);
	}


	@Override
	public void setNode(QName value) {
		this.getModelObject().setNode(value);
	}


	@Override
	public void setService(QName value) {
		this.getModelObject().setService(value);
	}


	@Override
	public EJaxbEndpointInformationType getModelObject() {
		return super.getModelObject();
	}




	

}
