/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl.env;

import java.util.List;
import java.util.Map.Entry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELInternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.component.bpel.impl.message.ESBContextImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.message.ESBExternalMessageImpl;
import com.ebmwebsourcing.easyesb.component.bpel.thread.NotifySenderCallable;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.model.registry.ProcessKey;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessKeyImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=Sender.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class ESBSenderImpl extends AbstractSenderImpl implements Sender {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    private static Logger log = Logger.getLogger(ESBSenderImpl.class.getName());

    private ExecutorService executorService = Executors.newFixedThreadPool(2);


    public ESBSenderImpl() {
        super();
    }

    @SuppressWarnings("unchecked")
    public void sendTo(final InternalMessage<?> internalMessage, final Endpoint providerEndpoint, final ExternalContext context) throws CoreException {
        final ESBContextImpl esbContext = (ESBContextImpl)context;
        try {
            // retrieve the esb context
            if(providerEndpoint.getInvokedOperation() == null) {
                providerEndpoint.setInvokedOperation(esbContext.getInitialExchange().getOperation());
            }

            // format message
            //TODO workaround to the ClassCastException between BPELInternalMessageImpl and InternalMessage<?>
            BPELInternalMessageImpl tmp = new BPELInternalMessageImpl();

            tmp.setContent((org.jdom.Element) internalMessage.getContent());
            tmp.setEndpoint(internalMessage.getEndpoint());
            tmp.setHeader(internalMessage.getHeader());
            tmp.setOperationName(internalMessage.getOperationName());
            tmp.setQName(internalMessage.getQName());
            tmp.setService(internalMessage.getService());
            tmp.setBody((com.ebmwebsourcing.easyviper.core.api.soa.message.Body<org.jdom.Element>) internalMessage.getBody());
            tmp.setDocumentation(internalMessage.getDocumentation());


            final InternalMessage formattedInternalMessage = tmp; //(BPELInternalMessageImpl) internalMessage;

            ESBExternalMessageImpl externalMessage = (ESBExternalMessageImpl) this.messageConverter.createExternalMessageFromInternalMessage(formattedInternalMessage);


            log.finest("Asynchronous send: PROVIDER ENDPOINT NAME: " + providerEndpoint.getEndpointName());
            if(externalMessage != null) {
                log.finest("MESSAGE SENT BY BPEL ENGINE: \n" + externalMessage);
            } else {
                final Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                final Element elmt = doc.createElement("null");
                doc.appendChild(elmt);
                externalMessage = new ESBExternalMessageImpl();
                externalMessage.setContent(doc.getDocumentElement());
                log.finest("MESSAGE SENT BY BPEL ENGINE: \n" + externalMessage);
            }


            /** TODO Check if the role for this partner for this endpoint is MyRole or PartnerRole  **/

            ProcessKey pk = new ProcessKeyImpl(null, providerEndpoint.getServiceName(), providerEndpoint.getEndpointName());
            List<Process> processes = this.getExternalEnvironment().getEngine().getProcessInstanceRegistry().getProcessInstances(pk);

            PartnerLink pl = null;
            boolean myrole = false;
            if(processes != null && processes.size() > 0){
                for(Entry<Object, Endpoint> e : processes.get(0).getEndpoints().entrySet()){
                    log.finest(e.getKey()+"::"+e.getValue().getEndpointName());
                    if(e.getValue().equals(providerEndpoint)){
                        pl = (PartnerLink) e.getKey();
                        if(pl.getMyRole() != null){
                            myrole = true;
                        }

                        break;
                    }
                }


            }


            if (!myrole){
                //TODO Way of sending should be abstracted and asked to the node that will know which Sender to use according to the endpoint
                //to invoke
                if(providerEndpoint.getEndpointName() == null && providerEndpoint.getServiceName() == null && providerEndpoint.getAddress() != null){

                    NotifySenderCallable callable = new NotifySenderCallable(externalMessage.getContent().getOwnerDocument(), providerEndpoint.getAddress(), null);//"http://petals.ow2.org/wsdm/Notify");

                    this.executorService.submit(callable);
                    

                }else{

                    log.finest("send to partner: " + providerEndpoint.getEndpointName());

                    // retrieve the sender
                    final com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint providerEp = esbContext. getProviderEndpoint();

                    // send the message
                    Exchange ex = ((ClientEndpoint)providerEp).createExchange();
                    ex.setDestination(new QName(providerEndpoint.getServiceName().getNamespaceURI(), providerEndpoint.getEndpointName()));
                    //ex.setOperation(new QName(providerEndpoint.getServiceName().getNamespaceURI(), providerEndpoint.getInvokedOperation()).toString());
                    ex.setOperation(new QName(providerEndpoint.getInterfaceName().getNamespaceURI(), providerEndpoint.getInvokedOperation()).toString());
                    ex.setInterfaceName(providerEndpoint.getInterfaceName());
                    ex.setPattern(PatternType.IN_ONLY);


                    MessageIn msgIn = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
                    Body body = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                    msgIn.setBody(body);
                    ex.setMessageIn(msgIn);
                    ex.getMessageIn().getBody().setPayload(externalMessage.getContent().getOwnerDocument());

                    ((ClientEndpoint)providerEp).send(ex);
                }

            } else {
                // set the response in exchange
                log.finest("send response to client");

                // retrieve the exchange
                final Exchange exchange = esbContext.getInitialExchange();

                // set the response
                if(exchange.getMessageOut() == null ) {
                    MessageOut msgOut = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
                    exchange.setMessageOut(msgOut);
                }
                if(exchange.getMessageOut().getBody() == null ) {
                    Body body = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                    exchange.getMessageOut().setBody(body);
                }
                exchange.getMessageOut().getBody().setPayload(externalMessage.getContent().getOwnerDocument());

                // set status if not already done
                exchange.setStatus(StatusType.DONE);

                // retrieve the sender
                final com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint providerEp = esbContext.getProviderEndpoint();

                providerEp.sendResponseToClient(exchange);
            }
        } catch (final ParserConfigurationException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } catch (final BPELException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } catch (ExchangeException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } catch (TransportException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        }
    }

    @SuppressWarnings("unchecked")
    public InternalMessage<?> sendSyncTo(final InternalMessage<?> message, final Endpoint providerEndpoint, final ExternalContext context) throws CoreException {
        InternalMessage<?> internalMessage = null;
        // retrieve the esb context
        final ESBContextImpl esbContext = (ESBContextImpl)context;
        try {

            if(providerEndpoint.getInvokedOperation() == null) {
                providerEndpoint.setInvokedOperation(esbContext.getInitialExchange().getOperation());
            }

            // format message
            final InternalMessage formattedInternalMessage = (BPELInternalMessageImpl) message;

            log.finest("Synchronous send: PROVIDER ENDPOINT NAME: " + providerEndpoint.getEndpointName());
            ESBExternalMessageImpl externalMessage = (ESBExternalMessageImpl) this.messageConverter.createExternalMessageFromInternalMessage(formattedInternalMessage);
            if(externalMessage != null) {
                log.finest("MESSAGE SENT SYNC BY BPEL engine: \n" + externalMessage);
            } else {
                final Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                final Element elmt = doc.createElement("null");
                doc.appendChild(elmt);
                externalMessage = new ESBExternalMessageImpl();
                externalMessage.setContent(doc.getDocumentElement());
                log.finest("MESSAGE SENT SYNC BY BPEL engine: \n" + externalMessage);
            }


            // retrieve the sender
            ProviderEndpoint providerEp = esbContext.getProviderEndpoint();

            // send the message
            Exchange ex = ((ClientEndpoint)providerEp).createExchange();
            ex.setDestination(new QName(providerEndpoint.getServiceName().getNamespaceURI(), providerEndpoint.getEndpointName()));
            ex.setOperation(new QName(providerEndpoint.getServiceName().getNamespaceURI(), providerEndpoint.getInvokedOperation()).toString());
            ex.setInterfaceName(providerEndpoint.getInterfaceName());
            ex.setPattern(PatternType.IN_OUT);

            MessageIn msgIn = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
            Body body = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            msgIn.setBody(body);
            ex.setMessageIn(msgIn);
            ex.getMessageIn().getBody().setPayload(externalMessage.getContent().getOwnerDocument());

            ex = ((ClientEndpoint)providerEp).sendSync(ex, new Long(0));

            if(ex.getMessageError() == null || ex.getMessageError().getBody() == null || ex.getMessageError().getBody().getPayload() == null) {
                ESBExternalMessageImpl responseMessage = new ESBExternalMessageImpl();
                responseMessage.setEndpoint(providerEndpoint.getEndpointName());
                responseMessage.setOperationName(providerEndpoint.getInvokedOperation());
                responseMessage.setService(providerEndpoint.getServiceName());
                responseMessage.setContent(ex.getMessageOut().getBody().getPayload().getDocumentElement());
                internalMessage = this.messageConverter.createInternalMessageFromExternalMessage(responseMessage);
                if(internalMessage != null) {
                    log.finest("MESSAGE RECEIVED BY BPEL engine: \n" + internalMessage);
                } else {
                    log.finest("MESSAGE RECEIVED BY BPEL engine: \n" + internalMessage);
                }
            } else {
                // trow user defined exception
                BPELInternalMessage faultMsg = new BPELInternalMessageImpl();
                // convert dom to jdom
                DOMBuilder builder = new DOMBuilder();


                if(ex.getMessageError().getBody().getPayload() != null) {
                    org.jdom.Document faultJDoc = builder.build(ex.getMessageError().getBody().getPayload());
                    log.finest("fault on bpel send: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(faultJDoc));
                    faultMsg.setContent(faultJDoc.getRootElement());
                }
                faultMsg.setEndpoint(ex.getDestination().toString());
                faultMsg.setOperationName(ex.getOperation());
                faultMsg.setService(providerEndpoint.getServiceName());
                CoreException userEx = new CoreException();
                userEx.setFault(faultMsg);
                throw userEx;
            }


        } catch (final ParserConfigurationException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } catch (final BPELException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } catch (ExchangeException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } catch (TransportException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException(e);
        } 
        return internalMessage;
    }

    public void sendTo(CoreException e, ExternalContext context) throws CoreException {
        try {
            // retrieve the esb context
            final ESBContextImpl esbContext = (ESBContextImpl)context;    


            // retrieve the exchange
            final Exchange exchange = esbContext.getInitialExchange();

            // set the response
            log.warning("Send error: " + exchange.getPattern());

            if(PatternType.IN_OUT.equals(exchange.getPattern())) {
                if(e instanceof UserDefinedException) {
                    log.warning("Send business fault: \n" + e);
                } else {
                    log.warning("Send technical fault: \n" + e);
                    e.printStackTrace();
                }
                org.jdom.Element internalMsg = null;

                log.warning("mmmmmmmmmm e.getFault(): \n" + e.getFault());
                if(e.getFault() != null) {
                    internalMsg = (org.jdom.Element) e.getFault().getContent();
                }

                // convert jdom to dom
                DOMOutputter converter = new DOMOutputter();

                log.warning("internalMsg = " + internalMsg);
                if(internalMsg != null) {
                    org.w3c.dom.Document domDocument = converter.output(internalMsg.getDocument());
                    log.warning("fault on bpel send 2: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(internalMsg));

                    if(exchange.getMessageError() == null ) {
                        MessageError msgError = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
                        exchange.setMessageError(msgError);
                    }
                    if(exchange.getMessageError().getBody() == null ) {
                        Body body = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                        exchange.getMessageError().setBody(body);
                    }
                    exchange.getMessageError().getBody().setPayload(domDocument);
                }

                // retrieve the sender
                ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
                log.finest("providerEp = " + providerEp);


                // notify the listener
                exchange.setStatus(StatusType.FAULT);
                providerEp.sendResponseToClient(exchange);
            }
        } catch (JDOMException e1) {
            throw new CoreException(e1);
        } catch (TransportException e1) {
            throw new CoreException(e1);
        } 

    }
}
