/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2006 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELInternalMessageImpl;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.marshalling.factory.MessageFactory;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageConverter;
import com.ebmwebsourcing.easyviper.core.impl.marshalling.factory.MessageFactoryImpl;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
public class ESBAndBpelMessageConverterImpl implements MessageConverter<ESBExternalMessageImpl, BPELInternalMessageImpl> {

    Class<BPELInternalMessageImpl> iImpl;

    Class<ESBExternalMessageImpl> eImpl;



    @SuppressWarnings("unchecked")
    public ESBAndBpelMessageConverterImpl(
            final Class<? extends ESBExternalMessageImpl> class1,
            final Class<? extends BPELInternalMessageImpl> class2) {
        this.iImpl = (Class<BPELInternalMessageImpl>) class2;
        this.eImpl = (Class<ESBExternalMessageImpl>) class1;
    }


    public ESBExternalMessageImpl createExternalMessageFromInternalMessage(final BPELInternalMessageImpl internalMessage)
    throws CoreException {
        ESBExternalMessageImpl externalMessage = null;
        if(internalMessage != null) {
            try {
                externalMessage = new ESBExternalMessageImpl();

                // convert jdom to dom
                if(internalMessage.getContent() != null) {
                    ByteArrayOutputStream internalMessageStream = new ByteArrayOutputStream();
                    XMLOutputter xmlout = new XMLOutputter();
                    xmlout.output(internalMessage.getContent().getDocument(), internalMessageStream);
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setNamespaceAware(true);
                    InputStream is = new ByteArrayInputStream(internalMessageStream.toByteArray());
                    org.w3c.dom.Document domdoc = factory.newDocumentBuilder().parse(is);
                    is.close();
                    externalMessage.setContent(domdoc.getDocumentElement());
                }

                externalMessage.setQName(internalMessage.getQName());
                externalMessage.setEndpoint(internalMessage.getEndpoint());
                externalMessage.setService(internalMessage.getService());
                externalMessage.setOperationName(internalMessage.getOperationName());
                externalMessage.setHeader(internalMessage.getHeader());
            } catch (final IllegalArgumentException e) {
                throw new CoreException(e);
            } catch (IOException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (SAXException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            } catch (ParserConfigurationException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
        }
        return externalMessage;
    }


    public BPELInternalMessageImpl createInternalMessageFromExternalMessage(final ESBExternalMessageImpl externalMessage) throws CoreException {
        BPELInternalMessageImpl internalMessage = null;
        if(externalMessage != null) {
            try {
                internalMessage = new BPELInternalMessageImpl();

                // convert dom to jdom
                if(externalMessage.getContent() != null) {
                    final DOMBuilder builder = new DOMBuilder();
                    final org.jdom.Document jdomDocument = builder.build(externalMessage.getContent().getOwnerDocument());
                    internalMessage.setContent(jdomDocument.getRootElement());
                }
                internalMessage.setQName(externalMessage.getQName());
                internalMessage.setEndpoint(externalMessage.getEndpoint());
                internalMessage.setService(externalMessage.getService());
                internalMessage.setOperationName(externalMessage.getOperationName());
                internalMessage.setHeader(externalMessage.getHeader());
            } catch (final IllegalArgumentException e) {
                throw new CoreException(e);
            } 
        }
        return internalMessage;
    }


    public Class<ESBExternalMessageImpl> getExternalMessageType() {
        return this.eImpl;
    }


    public Class<BPELInternalMessageImpl> getInternalMessageType() {
        return this.iImpl;
    }


	public MessageFactory<ExternalMessage<?>, InternalMessage<?>> getMessageFactory() {
		 return new MessageFactoryImpl(this.iImpl, this.eImpl);
	}




}
