/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpoint;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpointBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.impl.message.ESBContextImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.message.ESBExternalMessageImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.env.Receiver;

public class BPELProviderEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements BPELProviderEndpointBehaviour {


	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(BPELProviderEndpointBehaviourImpl.class.getName());

	static private Integer currentIndReceiver = 0;

	private Core core;

	public BPELProviderEndpointBehaviourImpl(
			Endpoint<? extends EndpointType> arg0) {
		super(arg0);
	}


	@SuppressWarnings("unchecked")
	public void execute(Exchange exchange) throws TransportException {
		assert(this.getBinding() != null);
		try {
			boolean found = false;
			for(org.petalslink.abslayer.service.api.BindingOperation bop: this.getBinding().getOperations()) {
				if(bop.inferQName().equals(QName.valueOf(exchange.getOperation()))) {
					found = true;
					break;
				}
			}
			if (found) {
				final ESBContextImpl context = new ESBContextImpl(exchange, (ProviderEndpoint) this.getEndpoint());
				final ESBExternalMessageImpl message = new ESBExternalMessageImpl();
				message.setEndpoint(exchange.getDestination().getLocalPart().toString());
				message.setService(((BPELProviderEndpoint)this.getEndpoint()).getServiceProvider().getQName());
				message.setOperationName(QName.valueOf(exchange.getOperation()).getLocalPart());
				message.setContent(exchange.getMessageIn().getBody().getPayload().getDocumentElement());
				synchronized(BPELProviderEndpointBehaviourImpl.currentIndReceiver) {
					if(BPELProviderEndpointBehaviourImpl.currentIndReceiver >= this.core.getExternalEnvironment().getReceivers().size()) {
						BPELProviderEndpointBehaviourImpl.currentIndReceiver = 0;
					}

					final Receiver receiver = this.core.getExternalEnvironment().getReceivers().get(BPELProviderEndpointBehaviourImpl.currentIndReceiver);
					BPELProviderEndpointBehaviourImpl.currentIndReceiver++;

					log.finest("Message accepted by receiver " + receiver.getName() + " :\n" + message);
					log.finest("Invoked operation:  " + message.getOperationName());

					synchronized(receiver) {
						receiver.accept(message, context);
					}
				}
				
				// add specific header property to exchange
				// to precise that exchange is accepted by provider
				exchange.getMessageIn().getHeader().addProperty(MessageUtil.getInstance().createHeaderProperty(MessageUtil.EXCHANGE_ACCEPTED_BY_PROVIDER_PROPERTY, "true"));
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new TransportException(e);
		}
	}

	public Core getCore() {
		return core;
	}


	public void setCore(Core core) {
		this.core = core;
	}
}
