/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.jdom.input.DOMBuilder;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.impl.wsdl11.DescriptionImpl;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Descriptions;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.resolver.URIMemoryMultipleResolvers;
import com.ebmwebsourcing.easycommons.research.util.io.ErrorUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponentBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpoint;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpointBehaviour;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy.SoapProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.AbstractComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver.EasyESBInternalURIResolver;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.resolver.FileInDeployURIResolver;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbBpelReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeploy;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployResponse;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbFault;
import easyesb.petalslink.com.component.bpel._1_0.BpelComponentExceptionMsg;
import easyesb.petalslink.com.component.bpel.data._1.ObjectFactory;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.StoreBpelResponse;
import easyesb.petalslink.com.component.bpel.data._1.UnstoreBpel;
import easyesb.petalslink.com.component.bpel.data._1.UnstoreBpelResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;


public class BPELComponentBehaviourImpl extends AbstractComponentBehaviourImpl implements BPELComponentBehaviour {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(BPELComponentBehaviourImpl.class.getName());

	private static Binding b; 
	static {
		try {

			// ADD ADMIN JAXB FACTORY
			SOAJAXBContext.getInstance().addOtherObjectFactory(ObjectFactory.class);
		} catch (SOAException e) {
			e.printStackTrace();
		}

		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(BPELComponentBehaviour.DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
			b = desc.getBindings().iterator().next();
		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new RuntimeException();
		} 
	}

	public BPELComponentBehaviourImpl(Component<? extends ComponentType> ep) {
		super(ep);
		this.setBinding(b);

	}



	public void execute(Exchange exchange) throws TransportException {
		try {
			if(exchange.getMessageIn().getBody().getPayload() == null) {
				throw new TransportException("the message in cannot be null");
			}

			// convert dom to jdom
			DOMBuilder builder = new DOMBuilder();
			org.jdom.Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());

			if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("storeBpel")) {
				log.finest("Store Bpel");

				StoreBpel storeBpelRequest = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), StoreBpel.class);
				List<String> eps = this.storeBpel(storeBpelRequest.getBpelUrl());

				StoreBpelResponse storeBpelResponse = new StoreBpelResponse();
				for(String ep: eps) {
					storeBpelResponse.getBpelEndpointAddress().add(ep);
				}

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(storeBpelResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} else if(doc.getRootElement() != null &&
					doc.getRootElement().getName().equals("unstoreBpel")) {

				log.finest("UnStore Bpel");

				UnstoreBpel unstoreBpelRequest = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), UnstoreBpel.class);
				UnstoreBpelResponse storeBpelResponse = this.unstoreBpel(unstoreBpelRequest);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(storeBpelResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);
			} 
		} catch (BpelComponentExceptionMsg e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				MessageUtil.getInstance().createErrorMessageStructure(exchange);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				throw new TransportException(ex);
			}
		} catch (SOAException e) {
			throw new TransportException(e);
		}
	}

	public List<ProviderEndpointType> store(URL bpelurl) throws ESBException {
		List<ProviderEndpointType> res = new ArrayList<ProviderEndpointType>();
		try {

			log.finest("store method");
			BPELComponent bpelComponent = ((BPELComponent)this.getEndpoint());

			Core core = bpelComponent.getCore();

			BPELProcess definition = (BPELProcess) core.getModel().getRegistry().storeProcessDefinition(bpelurl.toURI(), new ProcessContextDefinitionImpl());

			List<org.petalslink.abslayer.service.api.Endpoint> endpoints = new ArrayList<org.petalslink.abslayer.service.api.Endpoint>();
			for(Interface itf: definition.getProcessInterfaces()) {
				for(org.petalslink.abslayer.service.api.Endpoint ep: definition.getImports().findEndpointsImplementingInterface(itf)) {
					if(!endpointNotExist(ep, endpoints)) {
						endpoints.add(ep);
					}	
				}
			}

			for(org.petalslink.abslayer.service.api.Endpoint endpoint: endpoints) {
				Service service = this.createService(endpoint.getService().getQName(), BusinessServiceImpl.class);
				EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
				context.setNumberOfThreads(5);
				BPELProviderEndpoint providerEndpoint = ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(endpoint.getName(), BPELProviderEndpointImpl.class, context);
				providerEndpoint.setCore(core);
				providerEndpoint.addBehaviourClass(BPELProviderEndpointBehaviourImpl.class);
				BPELProviderEndpointBehaviour bpelProviderEndpointBehaviour = providerEndpoint.findBehaviour(BPELProviderEndpointBehaviour.class);

				bpelProviderEndpointBehaviour.setBinding(endpoint.getBinding());
				providerEndpoint.refreshDescription();

				URI wsdlLocation = this.findLocationFromEndpoint(endpoint, definition);
				if(wsdlLocation == null) {
					throw new ESBException("Wsdl location of endpoint \"" + endpoint.getName() + "\" cannot be null!!!");
				}
				providerEndpoint.setWSDLDescriptionAddress(this.createURIFromLocation(bpelurl, wsdlLocation));


				bpelProviderEndpointBehaviour.setCore(core);
				res.add((ProviderEndpointType) providerEndpoint.getModel());

				//				Port p = (Port) endpoint.getModel();
				//				com.ebmwebsourcing.easywsdl11.api.element.Service s = (com.ebmwebsourcing.easywsdl11.api.element.Service) p.getXmlObjectParent();
				//				servicesToDelete.add(s);
			}

			// create partner if needed
			List<org.petalslink.abslayer.service.api.Endpoint> partnerEndpoints = new ArrayList<org.petalslink.abslayer.service.api.Endpoint>();
			for(PartnerLink pl: definition.getPartnerLinks()) {
				if((pl.getPartnerRole() != null) && (pl.getPartnerRole().trim().length() > 0)) {
					if(pl.getPartnerLinkType() != null) {
						final org.petalslink.abslayer.service.api.PartnerLinkType plt = definition.getImports().getPartnerLinkType(pl.getPartnerLinkType());
						if(plt != null) {
							final org.petalslink.abslayer.service.api.Role role = plt.getRole(pl.getPartnerRole());
							if(role != null){
								final Interface itf = role.findInterface(role.getInterfaceQName());
								if(itf != null) {
									for(org.petalslink.abslayer.service.api.Endpoint ep: definition.getImports().findEndpointsImplementingInterface(itf)) {
										if(!partnerEndpoints.contains(ep)) {
											partnerEndpoints.add(ep);
										}
									}
								}
							}
						}
					}
				}
			}


			RegistryEndpoint<?> registryEndpoint = (RegistryEndpoint<?>) this.getEndpoint().getNode().getRegistryEndpoint();
			if(registryEndpoint == null) {
				throw new ESBException("Impossible to find registry... Impossible to store bpel: " + bpelurl);
			}

			for(org.petalslink.abslayer.service.api.Endpoint endpoint: partnerEndpoints) {
				if(registryEndpoint.findBehaviour(RegistryEndpointBehaviour.class).getEndpoint(new QName(endpoint.getService().getQName().getNamespaceURI(), endpoint.getName())) == null) {
					Service service = ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).createService(endpoint.getService().getQName(), BusinessServiceImpl.class);
					EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
					context.setNumberOfThreads(5);
					ProviderProxyEndpoint providerEndpoint = (ProviderProxyEndpoint) ((ServiceBehaviour)service.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(endpoint.getName(), ProviderProxyEndpointImpl.class, context);
					providerEndpoint.addBehaviourClass(SoapProviderProxyBehaviourImpl.class);

					providerEndpoint.setExternalAddress(endpoint.getAddress());
					//	((AbstractEndpointImpl<?>)providerEndpoint).setDescription(WSDL4ComplexWsdlFactory.newInstance().addExtElmt2Description((org.ow2.easywsdl.wsdl.api.Description)((AbstractWSDLElementImpl)endpoint.getService()).getParent()));
					URI wsdlLocation = this.findLocationFromEndpoint(endpoint, definition);
					if(wsdlLocation == null) {
						throw new ESBException("Wsdl location of endpoint \"" + endpoint.getName() + "\" cannot be null!!!");
					}
					providerEndpoint.setWSDLDescriptionAddress(this.createURIFromLocation(bpelurl, wsdlLocation));

					log.finest("*************** create partner: " + providerEndpoint.getName());
				}
			}

		} catch (CoreException e) {
			log.severe("ERROR e : " + e.getMessage());
			e.printStackTrace();
			throw new ESBException(e);
		} catch (URISyntaxException e) {
			log.severe("ERROR e : " + e.getMessage());
			e.printStackTrace();
			throw new ESBException(e);
		} catch (Exception e) {
			log.severe("ERROR +e : " + e.getMessage());
			e.printStackTrace();
			throw new ESBException(e);
		}

		return res;
	}



	private URI createURIFromLocation(URL bpelurl, URI location) {
		URI res = null;
		String path = bpelurl.toString().substring(0, bpelurl.toString().lastIndexOf("/")+1);

		res = URI.create(path + location.toString());
		return res;
	}

	private URI findLocationFromEndpoint(org.petalslink.abslayer.service.api.Endpoint ep, BPELProcess def) {
		URI res = null;
		org.petalslink.abslayer.service.api.Description desc = ep.getService().getDescription();
		DescriptionImpl.setXmlContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()));
		if(def != null) {
			break2:for(Import impt: def.getImports().getBPELImports()) {
				if(impt.getDescription() != null) {
					org.petalslink.abslayer.service.api.Description d = impt.getDescription();
					if(impt.getNamespace().toString().equals(desc.getTargetNamespace().toString()) &&
							d.findEndpoint(ep.getName()) != null) {
						res = impt.getLocation();
						break break2;
					}
					if(res == null) {
						res = findLocationFromEndpoint(ep, impt.getDescription()) ;
					}						
				}
			}
		}
		if(res == null) {
			for(Import impt: def.getImports().getBPELImports()) {
				if(impt.getNamespace().toString().equals(desc.getTargetNamespace().toString())) {
					res = impt.getLocation();
					break;
				}
			}
		}
		return res;
	}

	private URI findLocationFromEndpoint(org.petalslink.abslayer.service.api.Endpoint ep, org.petalslink.abslayer.service.api.Description parentDescription) {
		URI res = null;
		org.petalslink.abslayer.service.api.Description desc = ep.getService().getDescription();
		DescriptionImpl.setXmlContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()));
		for(org.petalslink.abslayer.service.api.Import impt: parentDescription.getImports()) {
			if(impt.getNamespace().equals(desc.getTargetNamespace())) {
				res = URI.create(impt.getLocation());
				break;
			}
			if(res == null) {
				if(impt.getImportDescription() != null) {
					res = findLocationFromEndpoint(ep, impt.getImportDescription()) ;
				}
			}
		}

		return res;
	}



	private boolean endpointNotExist(org.petalslink.abslayer.service.api.Endpoint ep, List<org.petalslink.abslayer.service.api.Endpoint> endpoints) {
		boolean res = false;
		for(org.petalslink.abslayer.service.api.Endpoint tmp: endpoints) {
			if(tmp.getName().equals(ep.getName()) && tmp.getService().getQName().getNamespaceURI().equals(ep.getService().getQName().getNamespaceURI())
					&& tmp.getService().getQName().getLocalPart().equals(ep.getService().getQName().getLocalPart())) {
				res = true;
				break;
			}
		}
		return res;
	}



	public List<ProviderEndpointType> unstore(URL bpel) throws ESBException {
		throw new ESBException("NotImplememented");
	}



	@Override
	public UnstoreBpelResponse unstoreBpel(UnstoreBpel parameters)
			throws BpelComponentExceptionMsg {
		UnstoreBpelResponse res = new UnstoreBpelResponse();
		try {
			List<ProviderEndpointType> eps = this.unstore(URI.create(parameters.getBpelUrl()).toURL());
			for(ProviderEndpointType ep: eps) {
				res.getBpelEndpointAddress().add(ep.getService() + "::" + ep.getName());
			}
		} catch (MalformedURLException e) {
			throw new BpelComponentExceptionMsg("StoreBpel operation error", e);
		} catch (ESBException e) {
			throw new BpelComponentExceptionMsg("StoreBpel operation error", e);
		}

		return res;
	}



	@Override
	public List<String> storeBpel(String bpelUrl)
			throws BpelComponentExceptionMsg {
		List<String> res = null;
		try {
			List<ProviderEndpointType> eps = this.store(URI.create(bpelUrl).toURL());
			res = new ArrayList<String>();
			for(ProviderEndpointType ep: eps) {
				res.add(ep.getService() + "::" + ep.getName());
			}
		} catch (MalformedURLException e) {
			throw new BpelComponentExceptionMsg("StoreBpel operation error", e);
		} catch (ESBException e) {
			throw new BpelComponentExceptionMsg("StoreBpel operation error", e);
		}

		return res;
	}



	@Override
	public EJaxbDeployResponse deploy(EJaxbDeploy deploy)
			throws ManagementException {
		EJaxbDeployResponse result = new EJaxbDeployResponse();
		try {
			URIMemoryMultipleResolvers resolvers = (URIMemoryMultipleResolvers) SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getURIResolver();
			SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).setURIResolver(resolvers);
			DescriptionImpl.setXmlContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()));
			Descriptions.setXmlContext(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()));
			
			String bpelURL = deploy.getMainResource().getFileURI();
			if(deploy.getMainResource().getAttachment() != null) {
				
				throw new ManagementException("Unsupported!!! Use deploy from URL instead");
				
				/** TODO: to support this mode you must easyboxed EasyBPEL and Uncommented lines below
				if(SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getURIResolver() instanceof URIMemoryMultipleResolvers) {
					FileInDeployURIResolver deployResolver = new FileInDeployURIResolver();
					deployResolver.setDeployer(deploy);
					resolvers.addResolver(deployResolver);
				} 
				*/
			} 
			
			
			List<ProviderEndpointType> endpoints = this.store(new URL(bpelURL));
			EJaxbBpelReport bpelReport = new EJaxbBpelReport();

			SoapServer soapServer = (SoapServer) ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).getExternalServer(SoapServer.DEFAULT_NAME);
			for (ProviderEndpointType providerEndpointType : endpoints) {
				QName clientName = new QName(providerEndpointType.getName().getNamespaceURI(), providerEndpointType.getName().getLocalPart() + "_proxy");
				EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
				context.setNumberOfThreads(5);
				ClientProxyEndpoint proxyClientEndpoint = (ClientProxyEndpoint) ((NodeBehaviour)this.endpoint.getNode().findBehaviour(NodeBehaviour.class)).createClientEndpoint(clientName, ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, context);
				proxyClientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
				proxyClientEndpoint.setProviderServiceName(endpoints.get(0).getService());
				proxyClientEndpoint.setProviderEndpointName(endpoints.get(0).getName());
				SOAPListenerImpl soapListener = new SOAPListenerImpl(proxyClientEndpoint, soapServer); 
				proxyClientEndpoint.getExternalListeners().put("SOAP", soapListener);
				bpelReport.getExternalEndpointsAddressesCreated().add(proxyClientEndpoint.getExternalAddress());
			}

			EJaxbDeployementReport deploymentReport = new EJaxbDeployementReport();
			deploymentReport.setAny(bpelReport);
			result.setDeployementReport(deploymentReport);

		} catch (Exception e) {
			log.severe(e.getMessage());
			EJaxbFault f = new EJaxbFault();
			f.setMessage(e.getMessage());
			f.setStacktrace(ErrorUtil.printStackTrace(e));
			ManagementException resourcesFault = new ManagementException(e.getMessage(), f);
			throw resourcesFault;
		}
		return result;
	}



	@Override
	public List<String> getSupportedResourcesExtensions() {
		List<String> res = new ArrayList<String>();
		res.add("bpel");
		return res;
	}


}
