/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.component.bpel.impl;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

import com.ebmwebsourcing.easyesb.component.bpel.api.BPELProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.SOAElement;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyviper.core.api.Core;

@Scope("COMPOSITE")
@Service(value=BPELProviderEndpoint.class, names="service")
@PolicySets("frascati:scaEasyPrimitive")
public class BPELProviderEndpointImpl extends ProviderEndpointImpl<ProviderEndpointType> implements BPELProviderEndpoint {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	@Property(name="core", required=true)
	private Core core = null;
	
	public BPELProviderEndpointImpl() throws ESBException {
		super();
	}

	public BPELProviderEndpointImpl(ProviderEndpointType model, SOAElement<?> parent, Core core) throws ESBException {
		super(model, parent);
		this.core = core;
	}

	public Core getCore() {
		return this.core;
	}

	public void setCore(Core core) {
		this.core = core;
	}


}
